/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.graph.dominance;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.PredecessorsFunction;
import com.google.common.graph.SuccessorsFunction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.util.graph.dominance.DomInput;

public final class DomTree<T>
implements Iterable<T> {
    static final int UNDEFINED = -1;
    private final DomInput<T> input;
    private final int[] doms;

    private DomTree(DomInput<T> pInput, int[] pDoms) {
        this.input = pInput;
        this.doms = pDoms;
    }

    public static <T> DomTree<T> empty() {
        return new DomTree(DomInput.empty(), new int[0]);
    }

    public static <T> DomTree<T> forGraph(PredecessorsFunction<T> pPredecessorFunction, SuccessorsFunction<T> pSuccessorFunction, T pStartNode) {
        Preconditions.checkNotNull(pStartNode);
        Preconditions.checkNotNull(pSuccessorFunction);
        Preconditions.checkNotNull(pPredecessorFunction);
        DomInput<T> input = DomInput.forGraph(pPredecessorFunction, pSuccessorFunction, pStartNode);
        int[] doms = DomTree.computeDoms(input);
        return new DomTree<T>(input, doms);
    }

    public static <T, G extends PredecessorsFunction<T> & SuccessorsFunction<T>> DomTree<T> forGraph(G pGraph, T pStartNode) {
        return DomTree.forGraph(pGraph, pGraph, pStartNode);
    }

    private static int[] computeDoms(DomInput<?> pInput) {
        DomInput.PredecessorDataIterator predecessorsDataIterator = pInput.iteratePredecessorData();
        int startNodeId = 0;
        int[] doms = new int[pInput.getNodeCount()];
        boolean changed = true;
        Arrays.fill(doms, -1);
        doms[startNodeId] = startNodeId;
        while (changed) {
            changed = false;
            predecessorsDataIterator.reset();
            while (predecessorsDataIterator.hasNextNode()) {
                int nodeId = predecessorsDataIterator.nextNode();
                int idom = -1;
                if (nodeId == startNodeId) continue;
                while (predecessorsDataIterator.hasNextPredecessor()) {
                    int predecessorId = predecessorsDataIterator.nextPredecessor();
                    if (doms[predecessorId] == -1) continue;
                    idom = idom != -1 ? DomTree.intersect(doms, predecessorId, idom) : predecessorId;
                }
                if (doms[nodeId] == idom) continue;
                doms[nodeId] = idom;
                changed = true;
            }
        }
        doms[startNodeId] = -1;
        return doms;
    }

    private static int intersect(int[] pDoms, int pFst, int pSnd) {
        int fst = pFst;
        int snd = pSnd;
        while (fst != snd) {
            while (snd > fst) {
                snd = pDoms[snd];
            }
            while (fst > snd) {
                fst = pDoms[fst];
            }
        }
        return fst;
    }

    DomInput<T> getInput() {
        return this.input;
    }

    public int getNodeCount() {
        return this.input.getNodeCount();
    }

    private int getId(T pNode) {
        Preconditions.checkNotNull(pNode);
        @Nullable Integer id = this.input.getReversePostOrderId(pNode);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (String)"unknown node: %s", pNode);
        return id;
    }

    public Optional<T> getRoot() {
        return this.input.getNodeCount() > 0 ? Optional.of(this.input.getNodeForReversePostOrderId(0)) : Optional.empty();
    }

    public Optional<T> getParent(T pNode) {
        int parentId = this.doms[this.getId(pNode)];
        return parentId != -1 ? Optional.of(this.input.getNodeForReversePostOrderId(parentId)) : Optional.empty();
    }

    int getParentId(int pId) {
        Preconditions.checkArgument((0 <= pId && pId < this.getNodeCount() ? 1 : 0) != 0, (String)"pId must be 0 <= ID < getNodeCount(), but is: %s", (int)pId);
        return this.doms[pId];
    }

    public boolean isAncestorOf(T pAncestorNode, T pDescendantNode) {
        int ancestorId = this.getId(pAncestorNode);
        int id = this.getId(pDescendantNode);
        while ((id = this.doms[id]) != -1) {
            if (id != ancestorId) continue;
            return true;
        }
        return false;
    }

    public ImmutableSet<T> getAncestors(T pNode) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int id = this.getId(pNode);
        while ((id = this.doms[id]) != -1) {
            builder.add(this.input.getNodeForReversePostOrderId(id));
        }
        return builder.build();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DomTree.this.getNodeCount();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return DomTree.this.input.getNodeForReversePostOrderId(this.index++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ImmutableGraph<T> asGraph() {
        MutableGraph mutableGraph = GraphBuilder.directed().allowsSelfLoops(false).nodeOrder(ElementOrder.stable()).expectedNodeCount(this.getNodeCount()).build();
        this.iterator().forEachRemaining(arg_0 -> ((MutableGraph)mutableGraph).addNode(arg_0));
        for (Object node : this) {
            this.getParent(node).ifPresent(parent -> mutableGraph.putEdge(parent, node));
        }
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean separator = false;
        for (T node : this) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(node);
            this.getParent(node).ifPresent(parent -> {
                sb.append(" --> ");
                sb.append(parent);
            });
        }
        sb.append("]");
        return sb.toString();
    }
}

