/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.graph.dominance;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.google.common.truth.Truth;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.graph.dominance.DomFrontiers;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;

public final class DominanceTest {
    private static final String ENTRY_NODE = "ENTRY";
    private static final String EXIT_NODE = "EXIT";
    private static final String UNKNOWN_NODE = "UNKNOWN";

    private static <N> void assertDirectedAndNoSelfLoops(Graph<N> pGraph) {
        Truth.assertWithMessage((String)"Expected the graph to be directed.").that(Boolean.valueOf(pGraph.isDirected())).isTrue();
        Truth.assertWithMessage((String)"Expected the graph to forbid self-loops.").that(Boolean.valueOf(pGraph.allowsSelfLoops())).isFalse();
    }

    private static <N> void assertHasNextElement(Iterator<N> pIterator) {
        Truth.assertWithMessage((String)"Expected that the iterator has a next element.").that(Boolean.valueOf(pIterator.hasNext())).isTrue();
    }

    private static <N> void assertNoNextElement(Iterator<N> pIterator) {
        Truth.assertWithMessage((String)"Expected that the iterator has no more elements.").that(Boolean.valueOf(pIterator.hasNext())).isFalse();
        Assert.assertThrows(NoSuchElementException.class, () -> pIterator.next());
    }

    private static <N> void assertRemoveUnsupported(Iterator<N> pIterator) {
        Assert.assertThrows(UnsupportedOperationException.class, () -> pIterator.remove());
    }

    @Test
    public void testEmptyDomTree() {
        DomTree emptyDomTree = DomTree.empty();
        DomTreeTester tester = new DomTreeTester(emptyDomTree);
        tester.assertNodeCountIs(0);
        tester.assertHasNoRoot();
        tester.assertNodeIsUnknown(UNKNOWN_NODE);
    }

    @Test
    public void testEmptyDomTreeIterator() {
        DomTree emptyDomTree = DomTree.empty();
        Iterator emptyDomTreeIterator = emptyDomTree.iterator();
        DominanceTest.assertNoNextElement(emptyDomTreeIterator);
        DominanceTest.assertRemoveUnsupported(emptyDomTreeIterator);
    }

    @Test
    public void testEmptyDomTreeGraph() {
        DomTree emptyDomTree = DomTree.empty();
        ImmutableGraph emptyDomTreeGraph = emptyDomTree.asGraph();
        DominanceTest.assertDirectedAndNoSelfLoops(emptyDomTreeGraph);
        Truth.assertThat((Iterable)emptyDomTreeGraph.nodes()).isEmpty();
        Truth.assertThat((Iterable)emptyDomTreeGraph.edges()).isEmpty();
    }

    @Test
    public void testEmptyDomFrontiers() {
        DomTree emptyDomTree = DomTree.empty();
        DomFrontiers emptyDomTreeFrontiers = DomFrontiers.forDomTree(emptyDomTree);
        Assert.assertThrows(IllegalArgumentException.class, () -> emptyDomTreeFrontiers.getFrontier(UNKNOWN_NODE));
        Truth.assertThat(emptyDomTreeFrontiers.getIteratedFrontier(ImmutableSet.of())).isEmpty();
        Assert.assertThrows(IllegalArgumentException.class, () -> emptyDomTreeFrontiers.getIteratedFrontier(ImmutableSet.of((Object)UNKNOWN_NODE)));
    }

    private static Graph<String> createSingleNodeGraph() {
        MutableGraph singleNodeGraph = GraphBuilder.directed().build();
        singleNodeGraph.addNode((Object)ENTRY_NODE);
        return singleNodeGraph;
    }

    @Test
    public void testSingleNodeDomTree() {
        DomTree<String> singleNodeDomTree = DomTree.forGraph(DominanceTest.createSingleNodeGraph(), ENTRY_NODE);
        DomTreeTester<String> tester = new DomTreeTester<String>(singleNodeDomTree);
        tester.assertNodeCountIs(1);
        tester.assertRootIs(ENTRY_NODE);
        tester.assertThat(ENTRY_NODE).hasNoParent();
        tester.assertThat(ENTRY_NODE).hasNoAncestors();
        tester.assertThat(ENTRY_NODE).isNotAncestorOf(ENTRY_NODE);
        tester.assertNodeIsUnknown(UNKNOWN_NODE);
    }

    @Test
    public void testSingleNodeDomTreeIterator() {
        DomTree<String> singleNodeDomTree = DomTree.forGraph(DominanceTest.createSingleNodeGraph(), ENTRY_NODE);
        Iterator<String> singleNodeDomTreeIterator = singleNodeDomTree.iterator();
        DominanceTest.assertHasNextElement(singleNodeDomTreeIterator);
        DominanceTest.assertRemoveUnsupported(singleNodeDomTreeIterator);
        Truth.assertThat((String)singleNodeDomTreeIterator.next()).isEqualTo((Object)ENTRY_NODE);
        DominanceTest.assertRemoveUnsupported(singleNodeDomTreeIterator);
        DominanceTest.assertNoNextElement(singleNodeDomTreeIterator);
    }

    @Test
    public void testSingleNodeDomTreeGraph() {
        DomTree<String> singleNodeDomTree = DomTree.forGraph(DominanceTest.createSingleNodeGraph(), ENTRY_NODE);
        ImmutableGraph<String> singleNodeTreeGraph = singleNodeDomTree.asGraph();
        DominanceTest.assertDirectedAndNoSelfLoops(singleNodeTreeGraph);
        Truth.assertThat((Iterable)singleNodeTreeGraph.nodes()).containsExactly(new Object[]{ENTRY_NODE});
        Truth.assertThat((Iterable)singleNodeTreeGraph.edges()).isEmpty();
    }

    @Test
    public void testSingleNodeDomFrontiers() {
        DomTree<String> singleNodeDomTree = DomTree.forGraph(DominanceTest.createSingleNodeGraph(), ENTRY_NODE);
        DomFrontiers<String> singleNodeDomTreeFrontiers = DomFrontiers.forDomTree(singleNodeDomTree);
        Truth.assertThat(singleNodeDomTreeFrontiers.getFrontier(ENTRY_NODE)).isEmpty();
        Assert.assertThrows(IllegalArgumentException.class, () -> singleNodeDomTreeFrontiers.getFrontier(UNKNOWN_NODE));
        Truth.assertThat(singleNodeDomTreeFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of())).isEmpty();
        Truth.assertThat(singleNodeDomTreeFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of((Object)ENTRY_NODE))).isEmpty();
        Assert.assertThrows(IllegalArgumentException.class, () -> singleNodeDomTreeFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of((Object)UNKNOWN_NODE)));
    }

    private static Graph<String> createBranchingGraph() {
        MutableGraph branchingGraph = GraphBuilder.directed().build();
        branchingGraph.addNode((Object)ENTRY_NODE);
        branchingGraph.addNode((Object)"A");
        branchingGraph.addNode((Object)"B");
        branchingGraph.addNode((Object)"C");
        branchingGraph.addNode((Object)EXIT_NODE);
        branchingGraph.putEdge((Object)ENTRY_NODE, (Object)"A");
        branchingGraph.putEdge((Object)"A", (Object)EXIT_NODE);
        branchingGraph.putEdge((Object)ENTRY_NODE, (Object)"B");
        branchingGraph.putEdge((Object)"B", (Object)"C");
        branchingGraph.putEdge((Object)"C", (Object)EXIT_NODE);
        return branchingGraph;
    }

    @Test
    public void testBranchingDomTree() {
        Graph<String> branchingGraph = DominanceTest.createBranchingGraph();
        DomTree<String> branchingDomTree = DomTree.forGraph(branchingGraph, ENTRY_NODE);
        DomTreeTester<String> tester = new DomTreeTester<String>(branchingDomTree);
        tester.assertNodeCountIs(branchingGraph.nodes().size());
        tester.assertRootIs(ENTRY_NODE);
        tester.assertThat(ENTRY_NODE).hasNoParent();
        tester.assertThat("A").isChildOf(ENTRY_NODE);
        tester.assertThat("B").isChildOf(ENTRY_NODE);
        tester.assertThat("C").isChildOf("B");
        tester.assertThat(EXIT_NODE).isChildOf(ENTRY_NODE);
        tester.assertThat(ENTRY_NODE).hasNoAncestors();
        tester.assertThat("A").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat("A").isDescendantOf(ENTRY_NODE);
        tester.assertThat("B").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat("B").isDescendantOf(ENTRY_NODE);
        tester.assertThat("C").hasTheseAncestors(ENTRY_NODE, "B");
        tester.assertThat("C").isDescendantOf(ENTRY_NODE);
        tester.assertThat("C").isDescendantOf("B");
        tester.assertThat(EXIT_NODE).hasTheseAncestors(ENTRY_NODE);
        tester.assertThat(EXIT_NODE).isDescendantOf(ENTRY_NODE);
        tester.assertThat(ENTRY_NODE).isNotAncestorOf(ENTRY_NODE);
        for (String node : branchingGraph.nodes()) {
            tester.assertThat("A").isNotAncestorOf(node);
            if (!node.equals("C")) {
                tester.assertThat("B").isNotAncestorOf(node);
            }
            tester.assertThat("C").isNotAncestorOf(node);
            tester.assertThat(EXIT_NODE).isNotAncestorOf(node);
        }
    }

    @Test
    public void testBranchingDomTreeIterator() {
        Graph<String> branchingGraph = DominanceTest.createBranchingGraph();
        DomTree<String> branchingDomTree = DomTree.forGraph(branchingGraph, ENTRY_NODE);
        Truth.assertThat(branchingDomTree).containsExactly(branchingGraph.nodes().toArray());
    }

    @Test
    public void testBranchingDomTreeGraph() {
        Graph<String> branchingGraph = DominanceTest.createBranchingGraph();
        DomTree<String> branchingDomTree = DomTree.forGraph(branchingGraph, ENTRY_NODE);
        ImmutableGraph<String> branchingDomTreeGraph = branchingDomTree.asGraph();
        DominanceTest.assertDirectedAndNoSelfLoops(branchingDomTreeGraph);
        Truth.assertThat((Iterable)branchingDomTreeGraph.nodes()).containsExactly(branchingGraph.nodes().toArray());
        Truth.assertThat((Iterable)branchingDomTreeGraph.edges()).containsExactly(new Object[]{EndpointPair.ordered((Object)ENTRY_NODE, (Object)"A"), EndpointPair.ordered((Object)ENTRY_NODE, (Object)"B"), EndpointPair.ordered((Object)"B", (Object)"C"), EndpointPair.ordered((Object)ENTRY_NODE, (Object)EXIT_NODE)});
    }

    @Test
    public void testBranchingDomFrontiers() {
        Graph<String> branchingGraph = DominanceTest.createBranchingGraph();
        DomTree<String> branchingDomTree = DomTree.forGraph(branchingGraph, ENTRY_NODE);
        DomFrontiers<String> branchingDomFrontiers = DomFrontiers.forDomTree(branchingDomTree);
        Truth.assertThat(branchingDomFrontiers.getFrontier(ENTRY_NODE)).isEmpty();
        Truth.assertThat(branchingDomFrontiers.getFrontier("A")).containsExactly(new Object[]{EXIT_NODE});
        Truth.assertThat(branchingDomFrontiers.getFrontier("B")).containsExactly(new Object[]{EXIT_NODE});
        Truth.assertThat(branchingDomFrontiers.getFrontier("C")).containsExactly(new Object[]{EXIT_NODE});
        Truth.assertThat(branchingDomFrontiers.getFrontier(EXIT_NODE)).isEmpty();
        Truth.assertThat(branchingDomFrontiers.getIteratedFrontier(branchingGraph.nodes())).containsExactly(new Object[]{EXIT_NODE});
        Truth.assertThat(branchingDomFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of((Object)ENTRY_NODE, (Object)EXIT_NODE))).isEmpty();
        Truth.assertThat(branchingDomFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of((Object)ENTRY_NODE, (Object)EXIT_NODE, (Object)"A"))).containsExactly(new Object[]{EXIT_NODE});
    }

    private static Graph<String> createLoopGraph() {
        MutableGraph loopGraph = GraphBuilder.directed().build();
        loopGraph.addNode((Object)ENTRY_NODE);
        loopGraph.addNode((Object)"A");
        loopGraph.addNode((Object)"B");
        loopGraph.addNode((Object)"C");
        loopGraph.addNode((Object)EXIT_NODE);
        loopGraph.putEdge((Object)ENTRY_NODE, (Object)"A");
        loopGraph.putEdge((Object)"A", (Object)EXIT_NODE);
        loopGraph.putEdge((Object)"A", (Object)"B");
        loopGraph.putEdge((Object)"B", (Object)"C");
        loopGraph.putEdge((Object)"C", (Object)"A");
        return loopGraph;
    }

    @Test
    public void testLoopDomTree() {
        Graph<String> loopGraph = DominanceTest.createLoopGraph();
        DomTree<String> loopDomTree = DomTree.forGraph(loopGraph, ENTRY_NODE);
        DomTreeTester<String> tester = new DomTreeTester<String>(loopDomTree);
        tester.assertNodeCountIs(loopGraph.nodes().size());
        tester.assertRootIs(ENTRY_NODE);
        tester.assertThat(ENTRY_NODE).hasNoParent();
        tester.assertThat(ENTRY_NODE).isParentOf("A");
        tester.assertThat("A").isParentOf("B");
        tester.assertThat("A").isParentOf(EXIT_NODE);
        tester.assertThat("B").isParentOf("C");
        tester.assertThat(ENTRY_NODE).hasNoAncestors();
        tester.assertThat("A").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat("B").hasTheseAncestors(ENTRY_NODE, "A");
        tester.assertThat("C").hasTheseAncestors(ENTRY_NODE, "A", "B");
        tester.assertThat(EXIT_NODE).hasTheseAncestors(ENTRY_NODE, "A");
    }

    @Test
    public void testLoopDomTreeIterator() {
        Graph<String> loopGraph = DominanceTest.createLoopGraph();
        DomTree<String> loopDomTree = DomTree.forGraph(loopGraph, ENTRY_NODE);
        Truth.assertThat(loopDomTree).containsExactly(loopGraph.nodes().toArray());
    }

    @Test
    public void testLoopDomTreeGraph() {
        Graph<String> loopGraph = DominanceTest.createLoopGraph();
        DomTree<String> loopDomTree = DomTree.forGraph(loopGraph, ENTRY_NODE);
        ImmutableGraph<String> loopDomTreeGraph = loopDomTree.asGraph();
        DominanceTest.assertDirectedAndNoSelfLoops(loopDomTreeGraph);
        Truth.assertThat((Iterable)loopDomTreeGraph.nodes()).containsExactly(loopGraph.nodes().toArray());
        Truth.assertThat((Iterable)loopDomTreeGraph.edges()).containsExactly(new Object[]{EndpointPair.ordered((Object)ENTRY_NODE, (Object)"A"), EndpointPair.ordered((Object)"A", (Object)"B"), EndpointPair.ordered((Object)"B", (Object)"C"), EndpointPair.ordered((Object)"A", (Object)EXIT_NODE)});
    }

    @Test
    public void testLoopDomFrontiers() {
        Graph<String> loopGraph = DominanceTest.createLoopGraph();
        DomTree<String> loopDomTree = DomTree.forGraph(loopGraph, ENTRY_NODE);
        DomFrontiers<String> loopDomFrontiers = DomFrontiers.forDomTree(loopDomTree);
        Truth.assertThat(loopDomFrontiers.getFrontier(ENTRY_NODE)).isEmpty();
        Truth.assertThat(loopDomFrontiers.getFrontier("A")).containsExactly(new Object[]{"A"});
        Truth.assertThat(loopDomFrontiers.getFrontier("B")).containsExactly(new Object[]{"A"});
        Truth.assertThat(loopDomFrontiers.getFrontier("C")).containsExactly(new Object[]{"A"});
        Truth.assertThat(loopDomFrontiers.getFrontier(EXIT_NODE)).isEmpty();
        Truth.assertThat(loopDomFrontiers.getIteratedFrontier(loopGraph.nodes())).containsExactly(new Object[]{"A"});
        Truth.assertThat(loopDomFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of((Object)ENTRY_NODE, (Object)EXIT_NODE))).isEmpty();
        Truth.assertThat(loopDomFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C"))).containsExactly(new Object[]{"A"});
    }

    private static Graph<String> createInfiniteLoopGraph() {
        MutableGraph infiniteLoopGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        infiniteLoopGraph.addNode((Object)ENTRY_NODE);
        infiniteLoopGraph.addNode((Object)"A");
        infiniteLoopGraph.addNode((Object)"B");
        infiniteLoopGraph.addNode((Object)EXIT_NODE);
        infiniteLoopGraph.putEdge((Object)ENTRY_NODE, (Object)"A");
        infiniteLoopGraph.putEdge((Object)"A", (Object)"B");
        infiniteLoopGraph.putEdge((Object)"B", (Object)"B");
        infiniteLoopGraph.putEdge((Object)"A", (Object)EXIT_NODE);
        return infiniteLoopGraph;
    }

    @Test
    public void testInfiniteLoopPostDomTree() {
        Graph transposedInfiniteLoopGraph = Graphs.transpose(DominanceTest.createInfiniteLoopGraph());
        DomTree<String> infiniteLoopPostDomTree = DomTree.forGraph(transposedInfiniteLoopGraph, EXIT_NODE);
        DomTreeTester<String> tester = new DomTreeTester<String>(infiniteLoopPostDomTree);
        tester.assertNodeCountIs(Sets.difference((Set)transposedInfiniteLoopGraph.nodes(), (Set)ImmutableSet.of((Object)"B")).size());
        tester.assertRootIs(EXIT_NODE);
        tester.assertThat(EXIT_NODE).hasNoParent();
        tester.assertThat(EXIT_NODE).isParentOf("A");
        tester.assertThat("A").isParentOf(ENTRY_NODE);
        tester.assertNodeIsUnknown("B");
        tester.assertThat(EXIT_NODE).hasNoAncestors();
        tester.assertThat("A").hasTheseAncestors(EXIT_NODE);
        tester.assertThat(ENTRY_NODE).hasTheseAncestors(EXIT_NODE, "A");
    }

    @Test
    public void testInfiniteLoopPostDomTreeIterator() {
        Graph transposedInfiniteLoopGraph = Graphs.transpose(DominanceTest.createInfiniteLoopGraph());
        DomTree<String> infiniteLoopPostDomTree = DomTree.forGraph(transposedInfiniteLoopGraph, EXIT_NODE);
        Truth.assertThat(infiniteLoopPostDomTree).containsExactly(Sets.difference((Set)transposedInfiniteLoopGraph.nodes(), (Set)ImmutableSet.of((Object)"B")).toArray());
    }

    @Test
    public void testInfiniteLoopPostDomTreeGraph() {
        Graph transposedInfiniteLoopGraph = Graphs.transpose(DominanceTest.createInfiniteLoopGraph());
        DomTree<String> infiniteLoopPostDomTree = DomTree.forGraph(transposedInfiniteLoopGraph, EXIT_NODE);
        ImmutableGraph<String> infiniteLoopPostDomTreeGraph = infiniteLoopPostDomTree.asGraph();
        DominanceTest.assertDirectedAndNoSelfLoops(infiniteLoopPostDomTreeGraph);
        Truth.assertThat((Iterable)infiniteLoopPostDomTreeGraph.nodes()).containsExactly(Iterables.toArray(infiniteLoopPostDomTree, Object.class));
        Truth.assertThat((Iterable)infiniteLoopPostDomTreeGraph.edges()).containsExactly(new Object[]{EndpointPair.ordered((Object)EXIT_NODE, (Object)"A"), EndpointPair.ordered((Object)"A", (Object)ENTRY_NODE)});
    }

    @Test
    public void testInfiniteLoopPostDomFrontiers() {
        Graph transposedInfiniteLoopGraph = Graphs.transpose(DominanceTest.createInfiniteLoopGraph());
        DomTree<String> infiniteLoopPostDomTree = DomTree.forGraph(transposedInfiniteLoopGraph, EXIT_NODE);
        DomFrontiers<String> infiniteLoopPostDomFrontiers = DomFrontiers.forDomTree(infiniteLoopPostDomTree);
        Truth.assertThat(infiniteLoopPostDomFrontiers.getFrontier(ENTRY_NODE)).isEmpty();
        Truth.assertThat(infiniteLoopPostDomFrontiers.getFrontier("A")).isEmpty();
        Truth.assertThat(infiniteLoopPostDomFrontiers.getFrontier(EXIT_NODE)).isEmpty();
        Truth.assertThat(infiniteLoopPostDomFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.copyOf(infiniteLoopPostDomTree))).isEmpty();
        Assert.assertThrows(IllegalArgumentException.class, () -> infiniteLoopPostDomFrontiers.getFrontier("B"));
    }

    private static Graph<String> createExampleGraph() {
        MutableGraph exampleGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        exampleGraph.addNode((Object)ENTRY_NODE);
        exampleGraph.addNode((Object)"A");
        exampleGraph.addNode((Object)"A");
        exampleGraph.addNode((Object)"B");
        exampleGraph.addNode((Object)"C");
        exampleGraph.addNode((Object)"D");
        exampleGraph.addNode((Object)"E");
        exampleGraph.addNode((Object)"F");
        exampleGraph.addNode((Object)"G");
        exampleGraph.addNode((Object)"H");
        exampleGraph.addNode((Object)"I");
        exampleGraph.addNode((Object)"J");
        exampleGraph.addNode((Object)"K");
        exampleGraph.addNode((Object)"L");
        exampleGraph.addNode((Object)"M");
        exampleGraph.addNode((Object)"N");
        exampleGraph.addNode((Object)"O");
        exampleGraph.addNode((Object)"P");
        exampleGraph.addNode((Object)"Q");
        exampleGraph.addNode((Object)EXIT_NODE);
        exampleGraph.putEdge((Object)ENTRY_NODE, (Object)"A");
        exampleGraph.putEdge((Object)"A", (Object)"B");
        exampleGraph.putEdge((Object)"B", (Object)"B");
        exampleGraph.putEdge((Object)"B", (Object)"C");
        exampleGraph.putEdge((Object)"C", (Object)"Q");
        exampleGraph.putEdge((Object)ENTRY_NODE, (Object)"D");
        exampleGraph.putEdge((Object)"D", (Object)"E");
        exampleGraph.putEdge((Object)"D", (Object)"F");
        exampleGraph.putEdge((Object)"E", (Object)"C");
        exampleGraph.putEdge((Object)"E", (Object)"G");
        exampleGraph.putEdge((Object)"F", (Object)"G");
        exampleGraph.putEdge((Object)"F", (Object)"L");
        exampleGraph.putEdge((Object)"G", (Object)"D");
        exampleGraph.putEdge((Object)"G", (Object)"Q");
        exampleGraph.putEdge((Object)ENTRY_NODE, (Object)"H");
        exampleGraph.putEdge((Object)"H", (Object)"I");
        exampleGraph.putEdge((Object)"I", (Object)"J");
        exampleGraph.putEdge((Object)"J", (Object)"K");
        exampleGraph.putEdge((Object)"K", (Object)"L");
        exampleGraph.putEdge((Object)"L", (Object)"Q");
        exampleGraph.putEdge((Object)"H", (Object)"M");
        exampleGraph.putEdge((Object)"M", (Object)"N");
        exampleGraph.putEdge((Object)"N", (Object)"O");
        exampleGraph.putEdge((Object)"O", (Object)"O");
        exampleGraph.putEdge((Object)"N", (Object)"P");
        exampleGraph.putEdge((Object)"P", (Object)"L");
        exampleGraph.putEdge((Object)"Q", (Object)EXIT_NODE);
        return exampleGraph;
    }

    @Test
    public void testExampleDomTree() {
        Graph<String> exampleGraph = DominanceTest.createExampleGraph();
        DomTree<String> exampleDomTree = DomTree.forGraph(exampleGraph, ENTRY_NODE);
        DomTreeTester<String> tester = new DomTreeTester<String>(exampleDomTree);
        tester.assertNodeCountIs(exampleGraph.nodes().size());
        tester.assertRootIs(ENTRY_NODE);
        tester.assertThat(ENTRY_NODE).hasNoParent();
        tester.assertThat("A").isChildOf(ENTRY_NODE);
        tester.assertThat("B").isChildOf("A");
        tester.assertThat("C").isChildOf(ENTRY_NODE);
        tester.assertThat("D").isChildOf(ENTRY_NODE);
        tester.assertThat("E").isChildOf("D");
        tester.assertThat("F").isChildOf("D");
        tester.assertThat("G").isChildOf("D");
        tester.assertThat("H").isChildOf(ENTRY_NODE);
        tester.assertThat("I").isChildOf("H");
        tester.assertThat("J").isChildOf("I");
        tester.assertThat("K").isChildOf("J");
        tester.assertThat("L").isChildOf(ENTRY_NODE);
        tester.assertThat("M").isChildOf("H");
        tester.assertThat("N").isChildOf("M");
        tester.assertThat("O").isChildOf("N");
        tester.assertThat("P").isChildOf("N");
        tester.assertThat("Q").isChildOf(ENTRY_NODE);
        tester.assertThat(EXIT_NODE).isChildOf("Q");
        tester.assertThat(ENTRY_NODE).hasNoAncestors();
        tester.assertThat("A").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat("B").hasTheseAncestors(ENTRY_NODE, "A");
        tester.assertThat("C").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat("D").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat("E").hasTheseAncestors(ENTRY_NODE, "D");
        tester.assertThat("F").hasTheseAncestors(ENTRY_NODE, "D");
        tester.assertThat("G").hasTheseAncestors(ENTRY_NODE, "D");
        tester.assertThat("H").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat("I").hasTheseAncestors(ENTRY_NODE, "H");
        tester.assertThat("J").hasTheseAncestors(ENTRY_NODE, "H", "I");
        tester.assertThat("K").hasTheseAncestors(ENTRY_NODE, "H", "I", "J");
        tester.assertThat("L").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat("M").hasTheseAncestors(ENTRY_NODE, "H");
        tester.assertThat("N").hasTheseAncestors(ENTRY_NODE, "H", "M");
        tester.assertThat("O").hasTheseAncestors(ENTRY_NODE, "H", "M", "N");
        tester.assertThat("P").hasTheseAncestors(ENTRY_NODE, "H", "M", "N");
        tester.assertThat("Q").hasTheseAncestors(ENTRY_NODE);
        tester.assertThat(EXIT_NODE).hasTheseAncestors(ENTRY_NODE, "Q");
    }

    @Test
    public void testExampleDomFrontiers() {
        Graph<String> exampleGraph = DominanceTest.createExampleGraph();
        DomTree<String> exampleDomTree = DomTree.forGraph(exampleGraph, ENTRY_NODE);
        DomFrontiers<String> exampleDomFrontiers = DomFrontiers.forDomTree(exampleDomTree);
        Truth.assertThat(exampleDomFrontiers.getFrontier(ENTRY_NODE)).isEmpty();
        Truth.assertThat(exampleDomFrontiers.getFrontier("A")).containsExactly(new Object[]{"C"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("B")).containsExactly(new Object[]{"B", "C"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("C")).containsExactly(new Object[]{"Q"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("D")).containsExactly(new Object[]{"D", "C", "L", "Q"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("E")).containsExactly(new Object[]{"C", "G"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("F")).containsExactly(new Object[]{"G", "L"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("G")).containsExactly(new Object[]{"Q", "D"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("H")).containsExactly(new Object[]{"L"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("I")).containsExactly(new Object[]{"L"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("J")).containsExactly(new Object[]{"L"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("K")).containsExactly(new Object[]{"L"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("L")).containsExactly(new Object[]{"Q"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("M")).containsExactly(new Object[]{"L"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("N")).containsExactly(new Object[]{"L"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("O")).containsExactly(new Object[]{"O"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("P")).containsExactly(new Object[]{"L"});
        Truth.assertThat(exampleDomFrontiers.getFrontier("Q")).isEmpty();
        Truth.assertThat(exampleDomFrontiers.getFrontier(EXIT_NODE)).isEmpty();
        Truth.assertThat(exampleDomFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of((Object)"B", (Object)"I"))).containsExactly(new Object[]{"B", "C", "L", "Q"});
        Truth.assertThat(exampleDomFrontiers.getIteratedFrontier((Set<String>)ImmutableSet.of((Object)"E"))).containsExactly(new Object[]{"C", "G", "Q", "D", "L"});
    }

    @Test
    public void testExamplePostDomTree() {
        Graph transposedExampleGraph = Graphs.transpose(DominanceTest.createExampleGraph());
        DomTree<String> examplePostDomTree = DomTree.forGraph(transposedExampleGraph, EXIT_NODE);
        DomTreeTester<String> tester = new DomTreeTester<String>(examplePostDomTree);
        tester.assertNodeCountIs(Sets.difference((Set)transposedExampleGraph.nodes(), (Set)ImmutableSet.of((Object)"O")).size());
        tester.assertRootIs(EXIT_NODE);
        tester.assertThat(ENTRY_NODE).isChildOf("Q");
        tester.assertThat("A").isChildOf("B");
        tester.assertThat("B").isChildOf("C");
        tester.assertThat("C").isChildOf("Q");
        tester.assertThat("D").isChildOf("Q");
        tester.assertThat("E").isChildOf("Q");
        tester.assertThat("F").isChildOf("Q");
        tester.assertThat("G").isChildOf("Q");
        tester.assertThat("H").isChildOf("L");
        tester.assertThat("I").isChildOf("J");
        tester.assertThat("J").isChildOf("K");
        tester.assertThat("K").isChildOf("L");
        tester.assertThat("L").isChildOf("Q");
        tester.assertThat("M").isChildOf("N");
        tester.assertThat("N").isChildOf("P");
        tester.assertNodeIsUnknown("O");
        tester.assertThat("P").isChildOf("L");
        tester.assertThat("Q").isChildOf(EXIT_NODE);
        tester.assertThat(EXIT_NODE).hasNoParent();
        tester.assertThat(ENTRY_NODE).hasTheseAncestors(EXIT_NODE, "Q");
        tester.assertThat("A").hasTheseAncestors(EXIT_NODE, "Q", "B", "C");
        tester.assertThat("B").hasTheseAncestors(EXIT_NODE, "Q", "C");
        tester.assertThat("C").hasTheseAncestors(EXIT_NODE, "Q");
        tester.assertThat("D").hasTheseAncestors(EXIT_NODE, "Q");
        tester.assertThat("E").hasTheseAncestors(EXIT_NODE, "Q");
        tester.assertThat("F").hasTheseAncestors(EXIT_NODE, "Q");
        tester.assertThat("G").hasTheseAncestors(EXIT_NODE, "Q");
        tester.assertThat("H").hasTheseAncestors(EXIT_NODE, "Q", "L");
        tester.assertThat("I").hasTheseAncestors(EXIT_NODE, "Q", "J", "K", "L");
        tester.assertThat("J").hasTheseAncestors(EXIT_NODE, "Q", "K", "L");
        tester.assertThat("K").hasTheseAncestors(EXIT_NODE, "Q", "L");
        tester.assertThat("L").hasTheseAncestors(EXIT_NODE, "Q");
        tester.assertThat("M").hasTheseAncestors(EXIT_NODE, "Q", "N", "P", "L");
        tester.assertThat("N").hasTheseAncestors(EXIT_NODE, "Q", "P", "L");
        tester.assertNodeIsUnknown("O");
        tester.assertThat("P").hasTheseAncestors(EXIT_NODE, "Q", "L");
        tester.assertThat("Q").hasTheseAncestors(EXIT_NODE);
        tester.assertThat(EXIT_NODE).hasNoAncestors();
    }

    @Test
    public void testExamplePostDomFrontiers() {
        Graph transposedExampleGraph = Graphs.transpose(DominanceTest.createExampleGraph());
        DomTree<String> examplePostDomTree = DomTree.forGraph(transposedExampleGraph, EXIT_NODE);
        DomFrontiers<String> examplePostDomFrontiers = DomFrontiers.forDomTree(examplePostDomTree);
        Truth.assertThat(examplePostDomFrontiers.getFrontier(ENTRY_NODE)).isEmpty();
        Truth.assertThat(examplePostDomFrontiers.getFrontier("A")).containsExactly(new Object[]{ENTRY_NODE});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("B")).containsExactly(new Object[]{"B", ENTRY_NODE});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("C")).containsExactly(new Object[]{"E", ENTRY_NODE});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("D")).containsExactly(new Object[]{"G", ENTRY_NODE});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("E")).containsExactly(new Object[]{"D"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("F")).containsExactly(new Object[]{"D"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("G")).containsExactly(new Object[]{"F", "E"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("H")).containsExactly(new Object[]{ENTRY_NODE});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("I")).containsExactly(new Object[]{"H"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("J")).containsExactly(new Object[]{"H"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("K")).containsExactly(new Object[]{"H"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("L")).containsExactly(new Object[]{ENTRY_NODE, "F"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("M")).containsExactly(new Object[]{"H"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("N")).containsExactly(new Object[]{"H"});
        Assert.assertThrows(IllegalArgumentException.class, () -> examplePostDomFrontiers.getFrontier("O"));
        Truth.assertThat(examplePostDomFrontiers.getFrontier("P")).containsExactly(new Object[]{"H"});
        Truth.assertThat(examplePostDomFrontiers.getFrontier("Q")).isEmpty();
        Truth.assertThat(examplePostDomFrontiers.getFrontier(EXIT_NODE)).isEmpty();
    }

    private static final class DomTreeTester<N> {
        private final DomTree<N> domTree;

        private DomTreeTester(DomTree<N> pDomTree) {
            this.domTree = pDomTree;
        }

        private void assertNodeCountIs(int pNodeCount) {
            Truth.assertWithMessage((String)"Expected the node count of the dominator tree to be '%s', but it is '%s'.", (Object[])new Object[]{pNodeCount, this.domTree.getNodeCount()}).that(Integer.valueOf(this.domTree.getNodeCount())).isEqualTo((Object)pNodeCount);
        }

        private void assertHasNoRoot() {
            Truth.assertWithMessage((String)"Expected the dominator tree to have no root (i.e., be empty), but it is '%s'.", (Object[])new Object[]{this.domTree.getRoot().orElse(null)}).that(this.domTree.getRoot()).isEqualTo(Optional.empty());
        }

        private void assertRootIs(N pRootNode) {
            Truth.assertWithMessage((String)"Expected the root of the dominator tree to be '%s', but it is '%s'.", (Object[])new Object[]{pRootNode, this.domTree.getRoot().orElse(null)}).that(this.domTree.getRoot()).isEqualTo(Optional.of(pRootNode));
        }

        private void assertNodeIsUnknown(N pUnknownNode) {
            Truth.assertWithMessage((String)"Expected '%s' to be an unknown node, but the dominator tree contains it.", (Object[])new Object[]{pUnknownNode}).that(Boolean.valueOf(Iterables.contains(this.domTree, pUnknownNode))).isFalse();
            Assert.assertThrows(IllegalArgumentException.class, () -> this.domTree.getParent(pUnknownNode));
            Assert.assertThrows(IllegalArgumentException.class, () -> this.domTree.getAncestors(pUnknownNode));
            Object otherNode = Iterables.tryFind(this.domTree, element -> true).or(pUnknownNode);
            Assert.assertThrows(IllegalArgumentException.class, () -> this.domTree.isAncestorOf(otherNode, pUnknownNode));
            Assert.assertThrows(IllegalArgumentException.class, () -> this.domTree.isAncestorOf(pUnknownNode, otherNode));
        }

        private NodeTester assertThat(N pNode) {
            return new NodeTester(pNode);
        }

        private final class NodeTester {
            private final N node;

            private NodeTester(N pNode) {
                this.node = pNode;
            }

            private void hasNoParent() {
                Truth.assertWithMessage((String)"Expected '%s' to have no parent, but parent is '%s'.", (Object[])new Object[]{this.node, DomTreeTester.this.domTree.getParent(this.node).orElse(null)}).that(DomTreeTester.this.domTree.getParent(this.node)).isEqualTo(Optional.empty());
            }

            private void isParentOf(N pChildNode) {
                Truth.assertWithMessage((String)"Expected '%s' to be the parent of '%s', but parent is '%s'.", (Object[])new Object[]{this.node, pChildNode, DomTreeTester.this.domTree.getParent(pChildNode).orElse(null)}).that(DomTreeTester.this.domTree.getParent(pChildNode)).isEqualTo(Optional.of(this.node));
            }

            private void isChildOf(N pParentNode) {
                Truth.assertWithMessage((String)"Expected '%s' to be a child of '%s', but the parent of '%s' is '%s'.", (Object[])new Object[]{this.node, pParentNode, this.node, DomTreeTester.this.domTree.getParent(this.node).orElse(null)}).that(DomTreeTester.this.domTree.getParent(this.node)).isEqualTo(Optional.of(pParentNode));
            }

            private void isNotAncestorOf(N pDescendantNode) {
                Truth.assertWithMessage((String)"Expected '%s' to _not_ be an ancestor of '%s', but it is.", (Object[])new Object[]{this.node, pDescendantNode}).that(Boolean.valueOf(DomTreeTester.this.domTree.isAncestorOf(this.node, pDescendantNode))).isFalse();
            }

            private void isDescendantOf(N pAncestorNode) {
                Truth.assertWithMessage((String)"Expected '%s' to be a descendant of '%s', but it isn't.", (Object[])new Object[]{this.node, pAncestorNode}).that(Boolean.valueOf(DomTreeTester.this.domTree.isAncestorOf(pAncestorNode, this.node))).isTrue();
            }

            private void hasNoAncestors() {
                Truth.assertWithMessage((String)"Expected '%s' to have no ancestors, but ancestors are '%s'.", (Object[])new Object[]{this.node, DomTreeTester.this.domTree.getAncestors(this.node)}).that(DomTreeTester.this.domTree.getAncestors(this.node)).isEmpty();
            }

            private void hasTheseAncestors(Object ... pAncestorNodes) {
                Truth.assertWithMessage((String)"Expected '%s' to have '%s' as ancestors, but ancestors are '%s'.", (Object[])new Object[]{this.node, ImmutableSet.copyOf((Object[])pAncestorNodes), DomTreeTester.this.domTree.getAncestors(this.node)}).that(DomTreeTester.this.domTree.getAncestors(this.node)).containsExactly(pAncestorNodes);
            }
        }
    }
}

