/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.graph.dominance;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;

public final class DominanceUtils {
    private DominanceUtils() {
    }

    private static Iterable<CFANode> createNodeIterable(CFANode pNode, boolean pForward, Predicate<CFANode> pStop, Predicate<CFANode> pFilter) {
        if (pStop.test((Object)pNode)) {
            return Collections::emptyIterator;
        }
        Iterator iterator = (pForward ? CFAUtils.allSuccessorsOf(pNode) : CFAUtils.allPredecessorsOf(pNode)).iterator();
        return () -> Iterators.filter((Iterator)iterator, (Predicate)pFilter);
    }

    private static Iterable<CFANode> createPredecessorIterable(CFANode pNode, ImmutableSet<CFANode> pIgnoreSet) {
        return DominanceUtils.createNodeIterable(pNode, false, (Predicate<CFANode>)((Predicate)node -> node instanceof FunctionEntryNode), (Predicate<CFANode>)((Predicate)node -> !(node instanceof FunctionExitNode) && !pIgnoreSet.contains(node)));
    }

    private static Iterable<CFANode> createSuccessorIterable(CFANode pNode, ImmutableSet<CFANode> pIgnoreSet) {
        return DominanceUtils.createNodeIterable(pNode, true, (Predicate<CFANode>)((Predicate)node -> node instanceof FunctionExitNode), (Predicate<CFANode>)((Predicate)node -> !(node instanceof FunctionEntryNode) && !pIgnoreSet.contains(node)));
    }

    public static DomTree<CFANode> createFunctionDomTree(FunctionEntryNode pEntryNode) {
        return DomTree.forGraph(node -> DominanceUtils.createPredecessorIterable(node, (ImmutableSet<CFANode>)ImmutableSet.of()), node -> DominanceUtils.createSuccessorIterable(node, (ImmutableSet<CFANode>)ImmutableSet.of()), pEntryNode);
    }

    public static DomTree<CFANode> createFunctionPostDomTree(FunctionEntryNode pEntryNode) {
        return DomTree.forGraph(node -> DominanceUtils.createSuccessorIterable(node, (ImmutableSet<CFANode>)ImmutableSet.of()), node -> DominanceUtils.createPredecessorIterable(node, (ImmutableSet<CFANode>)ImmutableSet.of()), pEntryNode.getExitNode());
    }

    public static DomTree<CFANode> createFunctionDomTree(CFANode pStartNode, ImmutableSet<CFANode> pIgnoreSet) {
        return DomTree.forGraph(node -> DominanceUtils.createPredecessorIterable(node, pIgnoreSet), node -> DominanceUtils.createSuccessorIterable(node, pIgnoreSet), pStartNode);
    }

    public static DomTree<CFANode> createFunctionPostDomTree(CFANode pStartNode, ImmutableSet<CFANode> pIgnoreSet) {
        return DomTree.forGraph(node -> DominanceUtils.createSuccessorIterable(node, pIgnoreSet), node -> DominanceUtils.createPredecessorIterable(node, pIgnoreSet), pStartNode);
    }
}

