/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.harness;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.types.AFunctionType;
import org.sosy_lab.cpachecker.cfa.types.IAFunctionType;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.java.JMethodType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.util.harness.HarnessExporter;
import org.sosy_lab.cpachecker.util.harness.PredefinedTypes;
import org.sosy_lab.cpachecker.util.testcase.ExpressionTestValue;
import org.sosy_lab.cpachecker.util.testcase.InitializerTestValue;
import org.sosy_lab.cpachecker.util.testcase.TestValue;
import org.sosy_lab.cpachecker.util.testcase.TestVector;

class CodeAppender
implements Appendable {
    private static final String RETVAL_NAME = "retval";
    private final Appendable appendable;

    public CodeAppender(Appendable pAppendable) {
        this.appendable = Objects.requireNonNull(pAppendable);
    }

    public String toString() {
        return this.appendable.toString();
    }

    @CanIgnoreReturnValue
    private CodeAppender appendVectorIndexDeclaration(String pInputFunctionVectorIndexName) throws IOException {
        this.appendable.append("  static unsigned int ");
        this.appendable.append(pInputFunctionVectorIndexName);
        this.appendln(" = 0;");
        return this;
    }

    @CanIgnoreReturnValue
    public CodeAppender appendDeclaration(Type pType, String pName) throws IOException {
        this.appendable.append(pType.toASTString(pName));
        this.appendln(";");
        return this;
    }

    @CanIgnoreReturnValue
    public CodeAppender appendAssignment(String pRetvalName, ARightHandSide pValue) throws IOException {
        this.appendable.append(pRetvalName);
        this.appendable.append(" = ");
        this.appendable.append(pValue.toASTString());
        return this;
    }

    @CanIgnoreReturnValue
    CodeAppender appendAssignment(String pRetvalName, TestValue pValue) throws IOException {
        return this.appendAssignment(pRetvalName, pValue, true);
    }

    @CanIgnoreReturnValue
    private CodeAppender appendAssignment(String pRetvalName, TestValue pValue, boolean pEnclose) throws IOException {
        boolean hasAuxiliaryStatmenets;
        boolean bl = hasAuxiliaryStatmenets = !pValue.getAuxiliaryStatements().isEmpty();
        if (hasAuxiliaryStatmenets) {
            if (pEnclose) {
                this.appendable.append("{ ");
            }
            for (AAstNode auxiliaryStatement : pValue.getAuxiliaryStatements()) {
                this.appendable.append(auxiliaryStatement.toASTString());
                if (pEnclose) {
                    this.appendable.append(" ");
                    continue;
                }
                this.appendln();
            }
        }
        this.appendable.append(pRetvalName);
        this.appendable.append(" = ");
        this.appendable.append(pValue.getValue().toASTString());
        this.appendable.append(";");
        if (hasAuxiliaryStatmenets && pEnclose) {
            this.appendable.append(" }");
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CodeAppender appendln(String pLine) throws IOException {
        this.appendable.append(pLine);
        this.appendln();
        return this;
    }

    @CanIgnoreReturnValue
    public Appendable appendln() throws IOException {
        this.appendable.append(System.lineSeparator());
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public CodeAppender append(CharSequence pCsq) throws IOException {
        this.appendable.append(pCsq);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public CodeAppender append(char pChar) throws IOException {
        this.appendable.append(pChar);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public CodeAppender append(CharSequence pCsq, int pStart, int pEnd) throws IOException {
        this.appendable.append(pCsq, pStart, pEnd);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    public CodeAppender append(TestVector pVector) throws IOException {
        for (AVariableDeclaration inputVariable : pVector.getInputVariables()) {
            void var9_9;
            InitializerTestValue inputValue = pVector.getInputValue(inputVariable);
            List<AAstNode> auxiliaryStatmenets = inputValue.getAuxiliaryStatements();
            Type type = PredefinedTypes.getCanonicalType(inputVariable.getType());
            boolean requiresInitialization = HarnessExporter.canInitialize(type);
            if (requiresInitialization && !auxiliaryStatmenets.isEmpty()) {
                for (AAstNode aAstNode : inputValue.getAuxiliaryStatements()) {
                    this.appendln(aAstNode.toASTString());
                }
            }
            AInitializer initializer = !requiresInitialization ? null : inputValue.getValue();
            if (inputVariable instanceof CVariableDeclaration) {
                CVariableDeclaration cVariableDeclaration = new CVariableDeclaration(FileLocation.DUMMY, inputVariable.isGlobal(), CStorageClass.AUTO, (CType)inputVariable.getType(), inputVariable.getName(), inputVariable.getOrigName(), inputVariable.getQualifiedName(), (CInitializer)initializer);
            } else if (inputVariable instanceof JVariableDeclaration) {
                JVariableDeclaration jVariableDeclaration = new JVariableDeclaration(FileLocation.DUMMY, (JType)inputVariable.getType(), inputVariable.getName(), inputVariable.getOrigName(), inputVariable.getQualifiedName(), initializer, ((JVariableDeclaration)inputVariable).isFinal());
            } else {
                throw new AssertionError((Object)("Unsupported declaration type: " + inputVariable));
            }
            this.appendln(var9_9.toASTString());
        }
        for (AFunctionDeclaration inputFunction : pVector.getInputFunctions()) {
            List<ExpressionTestValue> inputValues = pVector.getInputValues(inputFunction);
            Type returnType = inputFunction.getType().getReturnType();
            this.append(inputFunction);
            this.appendln(" {");
            if (!returnType.equals(CVoidType.VOID)) {
                String inputFunctionVectorIndexName = "test_vector_index";
                if (inputValues.size() > 1) {
                    this.appendVectorIndexDeclaration(inputFunctionVectorIndexName);
                }
                this.append("  ");
                this.appendDeclaration(returnType, RETVAL_NAME);
                if (inputValues.size() == 1) {
                    this.append("  ");
                    this.appendAssignment(RETVAL_NAME, inputValues.iterator().next());
                    this.appendln();
                } else if (inputValues.size() > 1) {
                    this.append("  switch (");
                    this.append(inputFunctionVectorIndexName);
                    this.appendln(") {");
                    int i = 0;
                    for (TestValue testValue : inputValues) {
                        this.append("    case ");
                        this.append(Integer.toString(i));
                        this.append(": ");
                        this.appendAssignment(RETVAL_NAME, testValue);
                        this.appendln(" break;");
                        ++i;
                    }
                    this.appendln("  }");
                    this.append("  ++");
                    this.append(inputFunctionVectorIndexName);
                    this.appendln(";");
                }
                this.append("  return ");
                this.append(RETVAL_NAME);
                this.appendln(";");
            }
            this.appendln("}");
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CodeAppender append(AFunctionDeclaration pInputFunction) throws IOException {
        return this.append(CodeAppender.enforceParameterNames(pInputFunction).toASTString(pInputFunction.getName()));
    }

    private static AFunctionType enforceParameterNames(AFunctionDeclaration pInputFunction) {
        IAFunctionType functionType = pInputFunction.getType();
        if (functionType instanceof CFunctionType) {
            CFunctionType cFunctionType = (CFunctionType)functionType;
            return new CFunctionTypeWithNames(cFunctionType.getReturnType(), (List<CParameterDeclaration>)FluentIterable.from(CodeAppender.enforceParameterNames(pInputFunction.getParameters())).filter(CParameterDeclaration.class).toList(), functionType.takesVarArgs());
        }
        if (functionType instanceof JMethodType) {
            JMethodType methodType = (JMethodType)functionType;
            return new JMethodType(methodType.getReturnType(), (List<JType>)FluentIterable.from(CodeAppender.enforceParameterNames(pInputFunction.getParameters())).filter(JType.class).toList(), functionType.takesVarArgs());
        }
        throw new AssertionError((Object)("Unsupported function type: " + functionType.getClass()));
    }

    private static List<AParameterDeclaration> enforceParameterNames(List<? extends AParameterDeclaration> pParameters) {
        HashSet usedNames = Sets.newHashSetWithExpectedSize((int)pParameters.size());
        int i = 0;
        ArrayList<AParameterDeclaration> result = new ArrayList<AParameterDeclaration>(pParameters.size());
        for (AParameterDeclaration aParameterDeclaration : pParameters) {
            AParameterDeclaration declaration = aParameterDeclaration;
            if (!declaration.getName().isEmpty()) {
                usedNames.add(declaration.getName());
            } else {
                String name;
                while (!usedNames.add(name = "p" + i)) {
                    ++i;
                }
                if (declaration instanceof CParameterDeclaration) {
                    declaration = new CParameterDeclaration(FileLocation.DUMMY, (CType)declaration.getType(), name);
                } else if (declaration instanceof JParameterDeclaration) {
                    JParameterDeclaration jDecl = (JParameterDeclaration)declaration;
                    declaration = new JParameterDeclaration(FileLocation.DUMMY, jDecl.getType(), name, jDecl.getQualifiedName() + name, jDecl.isFinal());
                } else {
                    throw new AssertionError((Object)("Unsupported parameter declaration type: " + declaration.getClass()));
                }
            }
            result.add(declaration);
        }
        return result;
    }
}

