/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.harness;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.harness.CodeAppender;
import org.sosy_lab.cpachecker.util.harness.PredefinedTypes;
import org.sosy_lab.cpachecker.util.testcase.ExpressionTestValue;
import org.sosy_lab.cpachecker.util.testcase.InitializerTestValue;
import org.sosy_lab.cpachecker.util.testcase.TestValue;
import org.sosy_lab.cpachecker.util.testcase.TestVector;

@Options(prefix="testHarnessExport")
public class HarnessExporter {
    private static final String TMP_VAR = "__tmp_var";
    private static final String ERR_MSG = "cpa_witness2test: violation";
    private final CFA cfa;
    private final LogManager logger;
    private final CBinaryExpressionBuilder binExpBuilder;
    private final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    @Option(secure=true, description="Use the counterexample model to provide test-vector values")
    private boolean useModel = true;
    @Option(secure=true, description="Only genenerate for __VERIFIER_nondet calls")
    private boolean onlyVerifierNondet = false;

    public HarnessExporter(Configuration pConfig, LogManager pLogger, CFA pCFA) throws InvalidConfigurationException {
        this.cfa = pCFA;
        this.logger = pLogger;
        this.binExpBuilder = new CBinaryExpressionBuilder(this.cfa.getMachineModel(), this.logger);
        pConfig.inject((Object)this);
    }

    public void writeHarness(Appendable pTarget, ARGState pRootState, Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, CounterexampleInfo pCounterexampleInfo) throws IOException {
        Optional<TestVector.TargetTestVector> testVector = this.extractTestVector(pRootState, pIsRelevantState, pIsRelevantEdge, this.getValueMap(pCounterexampleInfo));
        if (testVector.isPresent()) {
            FluentIterable externalFunctions = this.getExternalFunctions();
            CodeAppender codeAppender = new CodeAppender(pTarget);
            codeAppender.appendln("struct _IO_FILE;");
            codeAppender.appendln("typedef struct _IO_FILE FILE;");
            codeAppender.appendln("extern struct _IO_FILE *stderr;");
            codeAppender.appendln("extern int fprintf(FILE *__restrict __stream, const char *__restrict __format, ...);");
            codeAppender.appendln("extern void exit(int __status) __attribute__ ((__noreturn__));");
            CFAEdge edgeToTarget = testVector.orElseThrow().getEdgeToTarget();
            Optional<AFunctionDeclaration> errorFunction = this.getErrorFunction(edgeToTarget);
            if (errorFunction.isPresent()) {
                codeAppender.append(errorFunction.orElseThrow());
                codeAppender.appendln(" {");
                codeAppender.appendln("  fprintf(stderr, \"cpa_witness2test: violation\\n\");");
                codeAppender.appendln("  exit(107);");
                codeAppender.appendln("}");
            } else {
                this.logger.log(Level.WARNING, new Object[]{"Could not find a call to an error function."});
            }
            if (externalFunctions.stream().anyMatch(PredefinedTypes::isVerifierAssume)) {
                codeAppender.appendln("void __VERIFIER_assume(int cond) { if (!(cond)) { exit(0); }}");
            }
            TestVector vector = this.completeExternalFunctions(testVector.orElseThrow().getVector(), (Iterable<AFunctionDeclaration>)(errorFunction.isPresent() ? FluentIterable.from(externalFunctions).filter(Predicates.not((Predicate)Predicates.equalTo((Object)errorFunction.orElseThrow()))) : externalFunctions));
            codeAppender.append(vector);
        } else {
            this.logger.log(Level.WARNING, new Object[]{"Could not export a test harness, some test-vector values are missing."});
        }
    }

    private Optional<AFunctionDeclaration> getErrorFunction(CFAEdge pEdgeToTarget) {
        AFunctionCall callStatement = null;
        if (pEdgeToTarget instanceof AStatementEdge) {
            AStatementEdge statementEdge = (AStatementEdge)pEdgeToTarget;
            AStatement statement = statementEdge.getStatement();
            if (statement instanceof AFunctionCall) {
                callStatement = (AFunctionCall)statement;
            }
        } else if (pEdgeToTarget instanceof FunctionCallEdge) {
            callStatement = ((FunctionCallEdge)pEdgeToTarget).getSummaryEdge().getExpression();
        }
        if (callStatement != null) {
            return this.getFunctionDeclaration(callStatement);
        }
        return Optional.empty();
    }

    private Optional<AFunctionDeclaration> getFunctionDeclaration(AFunctionCall pFunctionCall) {
        AFunctionCallExpression functionCallExpression = pFunctionCall.getFunctionCallExpression();
        AFunctionDeclaration declaration = functionCallExpression.getDeclaration();
        return Optional.ofNullable(declaration);
    }

    private Set<AFunctionDeclaration> getExternalFunctions() {
        final HashSet<AFunctionDeclaration> externalFunctions = new HashSet<AFunctionDeclaration>();
        CFATraversal.CFAVisitor externalFunctionCollector = new CFATraversal.CFAVisitor(){

            @Override
            public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
                return CFATraversal.TraversalProcess.CONTINUE;
            }

            @Override
            public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
                ADeclarationEdge declarationEdge;
                ADeclaration declaration;
                if (pEdge.getEdgeType() == CFAEdgeType.DeclarationEdge && (declaration = (declarationEdge = (ADeclarationEdge)pEdge).getDeclaration()) instanceof AFunctionDeclaration) {
                    AFunctionDeclaration functionDeclaration = (AFunctionDeclaration)declaration;
                    if (!HarnessExporter.this.cfa.getAllFunctionNames().contains(functionDeclaration.getName())) {
                        externalFunctions.add(functionDeclaration);
                    }
                }
                return CFATraversal.TraversalProcess.CONTINUE;
            }
        };
        CFATraversal.dfs().traverseOnce(this.cfa.getMainFunction(), externalFunctionCollector);
        return externalFunctions;
    }

    private TestVector completeExternalFunctions(TestVector pVector, Iterable<AFunctionDeclaration> pExternalFunctions) {
        TestVector result = pVector;
        for (AFunctionDeclaration functionDeclaration : pExternalFunctions) {
            if (PredefinedTypes.isPredefinedFunctionWithoutVerifierError(functionDeclaration) || pVector.contains(functionDeclaration)) continue;
            result = this.addDummyValue(result, functionDeclaration);
        }
        return result;
    }

    private Multimap<ARGState, CFAEdgeWithAssumptions> getValueMap(CounterexampleInfo pCounterexampleInfo) {
        if (this.useModel && pCounterexampleInfo.isPreciseCounterExample()) {
            return pCounterexampleInfo.getExactVariableValues();
        }
        return ImmutableListMultimap.of();
    }

    public Optional<TestVector.TargetTestVector> extractTestVector(ARGState pRootState, Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) {
        HashSet visited = new HashSet();
        ArrayDeque<State> stack = new ArrayDeque<State>();
        ArrayDeque<CFAEdge> lastEdgeStack = new ArrayDeque<CFAEdge>();
        stack.push(State.of(pRootState, TestVector.newTestVector()));
        visited.addAll(stack);
        while (!stack.isEmpty()) {
            State previous = (State)stack.pop();
            CFAEdge lastEdge = null;
            if (!lastEdgeStack.isEmpty()) {
                lastEdge = (CFAEdge)lastEdgeStack.pop();
            }
            if (AbstractStates.isTargetState(previous.argState)) {
                assert (lastEdge != null) : "Expected target state to be different from root state, but was not";
                return Optional.of(new TestVector.TargetTestVector(lastEdge, previous.testVector));
            }
            ARGState parent = previous.argState;
            Iterable<CFANode> parentLocs = AbstractStates.extractLocations(parent);
            for (ARGState child : parent.getChildren()) {
                if (!pIsRelevantState.apply((Object)child) || !pIsRelevantEdge.test(parent, child)) continue;
                Iterable<CFANode> childLocs = AbstractStates.extractLocations(child);
                for (CFANode parentLoc : parentLocs) {
                    for (CFANode childLoc : childLocs) {
                        CFAEdge edge;
                        Optional<State> nextState;
                        if (!parentLoc.hasEdgeTo(childLoc) || !(nextState = this.computeNextState(previous, child, edge = parentLoc.getEdgeTo(childLoc), pValueMap)).isPresent() || !visited.add(nextState.orElseThrow())) continue;
                        stack.push(nextState.orElseThrow());
                        lastEdgeStack.push(edge);
                    }
                }
            }
        }
        return Optional.empty();
    }

    private Optional<State> computeNextState(State pPrevious, ARGState pChild, CFAEdge pEdge, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) {
        if (pEdge instanceof AStatementEdge) {
            AStatementEdge statementEdge = (AStatementEdge)pEdge;
            return this.handleStatementEdge(pPrevious, pChild, statementEdge, pValueMap);
        }
        if (pEdge instanceof ADeclarationEdge) {
            ADeclarationEdge declarationEdge = (ADeclarationEdge)pEdge;
            return this.handleDeclarationEdge(pPrevious, pChild, declarationEdge, pValueMap);
        }
        return Optional.of(State.of(pChild, pPrevious.testVector));
    }

    private Optional<State> handleStatementEdge(State pPrevious, ARGState pChild, AStatementEdge pStatementEdge, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) {
        String name;
        AIdExpression idExpression;
        ASimpleDeclaration declaration;
        AExpression nameExpression;
        AFunctionCall functionCall;
        AFunctionCallExpression functionCallExpression;
        AFunctionDeclaration functionDeclaration;
        AStatement statement = pStatementEdge.getStatement();
        if (statement instanceof AFunctionCall && !PredefinedTypes.isPredefinedFunction(functionDeclaration = (functionCallExpression = (functionCall = (AFunctionCall)statement).getFunctionCallExpression()).getDeclaration()) && !(functionCallExpression.getExpressionType() instanceof CVoidType) && functionCallExpression.getExpressionType() != JSimpleType.getVoid() && (nameExpression = functionCallExpression.getFunctionNameExpression()) instanceof AIdExpression && (declaration = (idExpression = (AIdExpression)nameExpression).getDeclaration()) != null && this.cfa.getFunctionHead(name = declaration.getQualifiedName()) == null && (!this.onlyVerifierNondet || name.startsWith("__VERIFIER_nondet"))) {
            Optional<ExpressionTestValue> defaultValue;
            if (functionCall instanceof AFunctionCallStatement) {
                return this.handlePlainFunctionCall(pPrevious, pChild, functionCallExpression);
            }
            AFunctionCallAssignmentStatement assignment = (AFunctionCallAssignmentStatement)functionCall;
            Optional<State> nextState = this.handleFunctionCallAssignment(pStatementEdge, pPrevious, pChild, functionCallExpression, assignment, pValueMap);
            if (nextState.isPresent()) {
                return nextState;
            }
            if (!HarnessExporter.isSupported(functionDeclaration)) {
                if (HarnessExporter.returnsPointer(functionDeclaration)) {
                    return this.handlePointerCall(pPrevious, pChild, functionCallExpression);
                }
                if (HarnessExporter.returnsComposite(functionDeclaration)) {
                    return this.handleCompositeCall(pPrevious, pChild, functionCallExpression);
                }
                return this.handlePlainFunctionCall(pPrevious, pChild, functionCallExpression);
            }
            if (this.onlyVerifierNondet && name.startsWith("__VERIFIER_nondet") && (defaultValue = HarnessExporter.getDefaultValue(functionDeclaration.getType().getReturnType())).isPresent()) {
                return Optional.of(new State(pChild, pPrevious.testVector.addInputValue(functionDeclaration, defaultValue.orElseThrow())));
            }
            return Optional.empty();
        }
        return Optional.of(State.of(pChild, pPrevious.testVector));
    }

    private Optional<State> handleDeclarationEdge(State pPrevious, ARGState pChild, ADeclarationEdge pDeclarationEdge, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) {
        CVariableDeclaration variableDeclaration;
        ADeclaration declaration = pDeclarationEdge.getDeclaration();
        if (declaration instanceof CVariableDeclaration && (variableDeclaration = (CVariableDeclaration)declaration).getCStorageClass() == CStorageClass.EXTERN) {
            Optional<State> nextState = this.handleVariableDeclaration(pDeclarationEdge, pPrevious, pChild, variableDeclaration, pValueMap);
            if (nextState.isPresent()) {
                return nextState;
            }
            CType type = variableDeclaration.getType();
            Type canonicalType = PredefinedTypes.getCanonicalType(type);
            if (canonicalType instanceof CPointerType) {
                return Optional.of(State.of(pChild, this.handlePointerDeclaration(pPrevious.testVector, variableDeclaration)));
            }
            if (canonicalType instanceof CCompositeType) {
                return Optional.of(State.of(pChild, this.handleCompositeDeclaration(pPrevious.testVector, variableDeclaration)));
            }
            if (canonicalType instanceof CArrayType) {
                return Optional.of(State.of(pChild, this.handleArrayDeclaration(pPrevious.testVector, variableDeclaration)));
            }
            return Optional.of(State.of(pChild, pPrevious.testVector.addInputValue((AVariableDeclaration)variableDeclaration, HarnessExporter.getDummyInitializer(variableDeclaration.getType()))));
        }
        return Optional.of(State.of(pChild, pPrevious.testVector));
    }

    private static boolean isSupported(@Nullable AFunctionDeclaration pDeclaration) {
        if (pDeclaration == null) {
            return false;
        }
        return !HarnessExporter.returnsPointer(pDeclaration) && !HarnessExporter.returnsComposite(pDeclaration);
    }

    private static boolean returnsPointer(AFunctionDeclaration pDeclaration) {
        Type type = PredefinedTypes.getCanonicalType(pDeclaration.getType().getReturnType());
        return type instanceof CPointerType;
    }

    private static boolean returnsComposite(AFunctionDeclaration pDeclaration) {
        Type type = PredefinedTypes.getCanonicalType(pDeclaration.getType().getReturnType());
        return type instanceof CCompositeType;
    }

    private Optional<State> handleFunctionCallAssignment(CFAEdge pEdge, State pPrevious, ARGState pChild, AFunctionCallExpression pFunctionCallExpression, AFunctionCallAssignmentStatement assignment, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) {
        ALeftHandSide leftHandSide = assignment.getLeftHandSide();
        return this.handleEdge(pEdge, pPrevious, pChild, leftHandSide, value -> vector -> vector.addInputValue(pFunctionCallExpression.getDeclaration(), (AExpression)value), pValueMap);
    }

    private Optional<State> handleVariableDeclaration(CFAEdge pEdge, State pPrevious, ARGState pChild, AVariableDeclaration pVariableDeclaration, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) {
        AIdExpression leftHandSide;
        if (pVariableDeclaration instanceof CVariableDeclaration) {
            leftHandSide = new CIdExpression(pVariableDeclaration.getFileLocation(), (CSimpleDeclaration)((Object)pVariableDeclaration));
        } else if (pVariableDeclaration instanceof JVariableDeclaration) {
            JVariableDeclaration variableDeclaration = (JVariableDeclaration)pVariableDeclaration;
            leftHandSide = new JIdExpression(pVariableDeclaration.getFileLocation(), variableDeclaration.getType(), variableDeclaration.getName(), variableDeclaration);
        } else {
            throw new AssertionError((Object)("Unsupported declaration type: " + pVariableDeclaration));
        }
        return this.handleEdge(pEdge, pPrevious, pChild, leftHandSide, value -> vector -> vector.addInputValue(pVariableDeclaration, HarnessExporter.toInitializer(value)), pValueMap);
    }

    private Optional<State> handleEdge(CFAEdge pEdge, State pPrevious, ARGState pChild, ALeftHandSide pLeftHandSide, Function<AExpression, Function<TestVector, TestVector>> pUpdate, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) {
        ARGState argState = pChild;
        while (argState != null) {
            ARGState candidate;
            Collection<ARGState> nextCandidates;
            FluentIterable automatonStates = AbstractStates.asIterable(argState).filter(AutomatonState.class);
            for (Object automatonState : automatonStates) {
                for (AExpression assumption : ((AutomatonState)automatonState).getAssumptions()) {
                    Optional<AExpression> value = HarnessExporter.getOther(assumption, pLeftHandSide);
                    if (!value.isPresent()) continue;
                    AExpression v = HarnessExporter.castIfNecessary(pLeftHandSide.getExpressionType(), value.orElseThrow());
                    return Optional.of(new State(pChild, pUpdate.apply(v).apply(pPrevious.testVector)));
                }
            }
            Collection assumptions = pValueMap.get((Object)pPrevious.argState);
            if (assumptions != null) {
                Object automatonState;
                automatonState = FluentIterable.from((Iterable)assumptions).filter(e -> e.getCFAEdge().equals(pEdge)).transformAndConcat(CFAEdgeWithAssumptions::getExpStmts).transform(AExpressionStatement::getExpression).iterator();
                while (automatonState.hasNext()) {
                    AExpression assumption = (AExpression)automatonState.next();
                    Optional<AExpression> value = HarnessExporter.getOther(assumption, pLeftHandSide);
                    if (!value.isPresent()) continue;
                    AExpression v = HarnessExporter.castIfNecessary(pLeftHandSide.getExpressionType(), value.orElseThrow());
                    return Optional.of(new State(pChild, pUpdate.apply(v).apply(pPrevious.testVector)));
                }
            }
            if ((nextCandidates = argState.getChildren()).size() == 1 && argState.getEdgesToChild(candidate = nextCandidates.iterator().next()).stream().allMatch(e -> e instanceof AssumeEdge || AutomatonGraphmlCommon.handleAsEpsilonEdge(e))) {
                argState = candidate;
                continue;
            }
            argState = null;
        }
        return Optional.empty();
    }

    private Optional<State> handlePlainFunctionCall(State pPrevious, ARGState pChild, AFunctionCallExpression functionCallExpression) {
        TestVector newTestVector = this.addDummyValue(pPrevious.testVector, functionCallExpression.getDeclaration());
        return Optional.of(State.of(pChild, newTestVector));
    }

    private Optional<State> handlePointerCall(State pPrevious, ARGState pChild, AFunctionCallExpression pFunctionCallExpression) {
        TestVector newTestVector = this.handlePointerCall(pPrevious.testVector, pFunctionCallExpression.getDeclaration());
        return Optional.of(State.of(pChild, newTestVector));
    }

    private TestVector handlePointerCall(TestVector pTestVector, AFunctionDeclaration pDeclaration) {
        Type declarationType = pDeclaration.getType().getReturnType();
        Preconditions.checkArgument((boolean)(PredefinedTypes.getCanonicalType(declarationType) instanceof CPointerType));
        if (!(declarationType instanceof CPointerType)) {
            declarationType = PredefinedTypes.getCanonicalType(declarationType);
        }
        ExpressionTestValue pointerValue = this.handlePointer((CPointerType)declarationType, false);
        return pTestVector.addInputValue(pDeclaration, pointerValue);
    }

    private TestVector handlePointerDeclaration(TestVector pTestVector, AVariableDeclaration pVariableDeclaration) {
        Type declarationType = pVariableDeclaration.getType();
        Preconditions.checkArgument((boolean)(declarationType instanceof CPointerType));
        ExpressionTestValue pointerValue = this.handlePointer((CPointerType)declarationType, true);
        AExpression value = pointerValue.getValue();
        AInitializer initializer = HarnessExporter.toInitializer(value);
        InitializerTestValue initializerTestValue = InitializerTestValue.of(pointerValue.getAuxiliaryStatements(), initializer);
        return pTestVector.addInputValue(pVariableDeclaration, initializerTestValue);
    }

    private static AInitializer toInitializer(AExpression pValue) {
        if (pValue instanceof CExpression) {
            return new CInitializerExpression(FileLocation.DUMMY, (CExpression)pValue);
        }
        if (pValue instanceof JExpression) {
            return new JInitializerExpression(FileLocation.DUMMY, (JExpression)pValue);
        }
        throw new AssertionError((Object)("Unsupported expression type: " + pValue));
    }

    private ExpressionTestValue handlePointer(CPointerType pType, boolean pIsGlobal) {
        return this.handlePointer(pType, this.getSizeOf(pType.getType()), pIsGlobal);
    }

    private ExpressionTestValue handlePointer(CPointerType pType, CExpression pTargetSize, boolean pIsGlobal) {
        if (pIsGlobal) {
            String varName = "__tmp_var_" + this.idGenerator.getFreshId();
            CVariableDeclaration tmpDeclaration = new CVariableDeclaration(FileLocation.DUMMY, true, CStorageClass.AUTO, pType.getType(), varName, varName, varName, (CInitializer)HarnessExporter.getDummyInitializer(pType.getType()));
            CIdExpression var = new CIdExpression(FileLocation.DUMMY, tmpDeclaration);
            return ExpressionTestValue.of(Collections.singletonList(tmpDeclaration), new CUnaryExpression(FileLocation.DUMMY, pType, var, CUnaryExpression.UnaryOperator.AMPER));
        }
        ExpressionTestValue pointerValue = this.assignMallocToTmpVariable(pTargetSize, pType.getType(), false);
        return ExpressionTestValue.of(pointerValue.getAuxiliaryStatements(), pointerValue.getValue());
    }

    private Optional<State> handleCompositeCall(State pPrevious, ARGState pChild, AFunctionCallExpression pFunctionCallExpression) {
        AFunctionDeclaration declaration = pFunctionCallExpression.getDeclaration();
        TestVector newTestVector = this.handleCompositeCall(pPrevious.testVector, declaration);
        return Optional.of(State.of(pChild, newTestVector));
    }

    private TestVector handleCompositeCall(TestVector pTestVector, AFunctionDeclaration pDeclaration) {
        Preconditions.checkArgument((boolean)HarnessExporter.returnsComposite(pDeclaration));
        CType expectedTargetType = (CType)pDeclaration.getType().getReturnType();
        return pTestVector.addInputValue(pDeclaration, this.handleComposite(expectedTargetType, this.getSizeOf(expectedTargetType), false));
    }

    private TestVector handleCompositeDeclaration(TestVector pTestVector, AVariableDeclaration pVariableDeclaration) {
        Type expectedTargetType = pVariableDeclaration.getType();
        Preconditions.checkArgument((boolean)(PredefinedTypes.getCanonicalType(expectedTargetType) instanceof CCompositeType));
        return pTestVector.addInputValue(pVariableDeclaration, HarnessExporter.getDummyInitializer(pVariableDeclaration.getType()));
    }

    private ExpressionTestValue handleComposite(CType pType, CExpression pSize, boolean pIsGlobal) {
        Preconditions.checkArgument((boolean)(PredefinedTypes.getCanonicalType(pType) instanceof CCompositeType));
        CPointerType pointerType = new CPointerType(false, false, pType);
        ExpressionTestValue pointerValue = this.handlePointer(pointerType, pSize, pIsGlobal);
        CExpression pointerExpression = (CExpression)((TestValue)pointerValue).getValue();
        AExpression value = new CPointerExpression(FileLocation.DUMMY, CPointerType.POINTER_TO_VOID, (CExpression)HarnessExporter.castIfNecessary(pointerType, pointerExpression));
        value = HarnessExporter.castIfNecessary(pType, value);
        return ExpressionTestValue.of(pointerValue.getAuxiliaryStatements(), value);
    }

    private TestVector handleArrayDeclaration(TestVector pTestVector, AVariableDeclaration pVariableDeclaration) {
        return pTestVector.addInputValue(pVariableDeclaration, HarnessExporter.getDummyInitializer(pVariableDeclaration.getType()));
    }

    private ExpressionTestValue assignMallocToTmpVariable(CExpression pSize, CType pTargetType, boolean pIsGlobal) {
        CFunctionCallExpression pointerToValue = HarnessExporter.callMalloc(pSize);
        Object variableName = TMP_VAR;
        if (pIsGlobal) {
            variableName = (String)variableName + "_" + this.idGenerator.getFreshId();
        }
        CVariableDeclaration tmpVarDeclaration = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, new CPointerType(false, false, pTargetType), (String)variableName, (String)variableName, (String)variableName, null);
        CIdExpression variable = new CIdExpression(FileLocation.DUMMY, tmpVarDeclaration);
        CFunctionCallAssignmentStatement assignment = new CFunctionCallAssignmentStatement(FileLocation.DUMMY, variable, pointerToValue);
        return ExpressionTestValue.of((List<AAstNode>)ImmutableList.of((Object)tmpVarDeclaration, (Object)assignment), variable);
    }

    private CExpression getSizeOf(CType pExpectedTargetType) {
        AbstractExpression size;
        CType canonicalType = pExpectedTargetType.getCanonicalType();
        CIntegerLiteralExpression dummyLength = new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.UNSIGNED_INT, BigInteger.valueOf(4096L));
        if (canonicalType.equals(CVoidType.VOID)) {
            size = dummyLength;
        } else if (canonicalType instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)canonicalType;
            CExpression length = arrayType.getLength();
            if (length == null) {
                length = dummyLength;
            }
            size = this.binExpBuilder.buildBinaryExpressionUnchecked(this.getSizeOf(arrayType.getType()), length, CBinaryExpression.BinaryOperator.MULTIPLY);
        } else {
            size = new CTypeIdExpression(FileLocation.DUMMY, CNumericTypes.UNSIGNED_INT, CTypeIdExpression.TypeIdOperator.SIZEOF, pExpectedTargetType);
        }
        return size;
    }

    private static CFunctionCallExpression callMalloc(CExpression pSize) {
        CFunctionType type = new CFunctionType(CPointerType.POINTER_TO_VOID, Collections.singletonList(CNumericTypes.INT), false);
        CFunctionDeclaration functionDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, type, "malloc", (List<CParameterDeclaration>)ImmutableList.of((Object)new CParameterDeclaration(FileLocation.DUMMY, CPointerType.POINTER_TO_VOID, "size")), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
        return new CFunctionCallExpression(FileLocation.DUMMY, CPointerType.POINTER_TO_VOID, new CIdExpression(FileLocation.DUMMY, functionDeclaration), Collections.singletonList(pSize), functionDeclaration);
    }

    private TestVector addDummyValue(TestVector pTestVector, AFunctionDeclaration pFunctionDeclaration) {
        Type returnType = pFunctionDeclaration.getType().getReturnType();
        Type canonicalReturnType = PredefinedTypes.getCanonicalType(returnType);
        if (canonicalReturnType instanceof CPointerType) {
            return this.handlePointerCall(pTestVector, pFunctionDeclaration);
        }
        if (canonicalReturnType instanceof CCompositeType) {
            return this.handleCompositeCall(pTestVector, pFunctionDeclaration);
        }
        AExpression value = HarnessExporter.getDummyValue(pFunctionDeclaration.getType().getReturnType());
        return HarnessExporter.addValue(pTestVector, pFunctionDeclaration, value);
    }

    private static AExpression getDummyValue(Type pType) {
        if (pType instanceof CType) {
            CInitializer initializer;
            if (HarnessExporter.canInitialize(pType) && (initializer = CDefaults.forType((CType)pType, FileLocation.DUMMY)) instanceof CInitializerExpression) {
                return ((CInitializerExpression)initializer).getExpression();
            }
            return new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.UNSIGNED_INT, BigInteger.ZERO);
        }
        return new JIntegerLiteralExpression(FileLocation.DUMMY, BigInteger.ZERO);
    }

    private static AInitializer getDummyInitializer(Type pType) {
        if (pType instanceof CType) {
            if (HarnessExporter.canInitialize(pType)) {
                return CDefaults.forType((CType)pType, FileLocation.DUMMY);
            }
            return new CInitializerExpression(FileLocation.DUMMY, new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.UNSIGNED_INT, BigInteger.ZERO));
        }
        return new JInitializerExpression(FileLocation.DUMMY, new JIntegerLiteralExpression(FileLocation.DUMMY, BigInteger.ZERO));
    }

    private static Optional<ExpressionTestValue> getDefaultValue(Type pReturnType) {
        if (pReturnType instanceof CType) {
            CType returnType = ((CType)pReturnType).getCanonicalType();
            if (returnType instanceof CSimpleType && ((CSimpleType)returnType).getType() == CBasicType.CHAR) {
                return Optional.of(ExpressionTestValue.of(new CCharLiteralExpression(FileLocation.DUMMY, returnType, ' ')));
            }
            if (!(returnType instanceof CCompositeType || returnType instanceof CArrayType || returnType instanceof CBitFieldType || returnType instanceof CElaboratedType && ((CElaboratedType)returnType).getKind() != CComplexType.ComplexTypeKind.ENUM)) {
                return Optional.of(ExpressionTestValue.of(((CInitializerExpression)CDefaults.forType(returnType, FileLocation.DUMMY)).getExpression()));
            }
        }
        return Optional.empty();
    }

    static boolean canInitialize(Type pType) {
        Type canonicalType = PredefinedTypes.getCanonicalType(pType);
        if (canonicalType.equals(CVoidType.VOID)) {
            return false;
        }
        if (canonicalType instanceof CCompositeType) {
            return !((CCompositeType)canonicalType).isIncomplete();
        }
        if (canonicalType instanceof CElaboratedType) {
            return ((CElaboratedType)canonicalType).getKind() == CComplexType.ComplexTypeKind.ENUM;
        }
        return true;
    }

    private static TestVector addValue(TestVector pTestVector, AFunctionDeclaration pFunctionDeclaration, AExpression pValue) {
        AExpression value = HarnessExporter.castIfNecessary(pFunctionDeclaration.getType().getReturnType(), pValue);
        return pTestVector.addInputValue(pFunctionDeclaration, value);
    }

    private static AExpression castIfNecessary(Type pExpectedReturnType, AExpression pValue) {
        AExpression value = pValue;
        Type expectedReturnType = PredefinedTypes.getCanonicalType(pExpectedReturnType);
        Type actualType = PredefinedTypes.getCanonicalType(value.getExpressionType());
        if (!HarnessExporter.areTypesCompatible(pValue, expectedReturnType)) {
            if (value instanceof CExpression && expectedReturnType instanceof CType) {
                if (expectedReturnType instanceof CPointerType && !expectedReturnType.equals(CPointerType.POINTER_TO_VOID) && actualType instanceof CPointerType && !actualType.equals(CPointerType.POINTER_TO_VOID)) {
                    value = new CCastExpression(pValue.getFileLocation(), CPointerType.POINTER_TO_VOID, (CExpression)value);
                }
                value = new CCastExpression(pValue.getFileLocation(), (CType)pExpectedReturnType, (CExpression)value);
            } else if (value instanceof JExpression && expectedReturnType instanceof JType) {
                value = new JCastExpression(pValue.getFileLocation(), (JType)expectedReturnType, (JExpression)value);
            }
        }
        return value;
    }

    private static boolean areTypesCompatible(AExpression pValue, Type pExpectedType) {
        Type actualType = PredefinedTypes.getCanonicalType(pValue.getExpressionType());
        if (actualType.equals(pExpectedType)) {
            return true;
        }
        if (actualType instanceof CSimpleType && pExpectedType instanceof CSimpleType) {
            CSimpleType simpleActualType = (CSimpleType)actualType;
            CSimpleType simpleExpectedType = (CSimpleType)pExpectedType;
            if (simpleActualType.isUnsigned() && simpleExpectedType.isUnsigned()) {
                return true;
            }
        }
        return false;
    }

    private static Optional<AExpression> getOther(AExpression pAssumption, ALeftHandSide pLeftHandSide) {
        if (!(pAssumption instanceof ABinaryExpression)) {
            return Optional.empty();
        }
        ABinaryExpression binOp = (ABinaryExpression)pAssumption;
        if (binOp.getOperator() != CBinaryExpression.BinaryOperator.EQUALS && binOp.getOperator() != JBinaryExpression.BinaryOperator.EQUALS) {
            return Optional.empty();
        }
        if (binOp.getOperand1().equals(pLeftHandSide)) {
            return Optional.of(binOp.getOperand2());
        }
        if (binOp.getOperand2().equals(pLeftHandSide)) {
            return Optional.of(binOp.getOperand1());
        }
        return Optional.empty();
    }

    private static class State {
        private final ARGState argState;
        private final TestVector testVector;

        private State(ARGState pARGState, TestVector pTestVector) {
            this.argState = Objects.requireNonNull(pARGState);
            this.testVector = Objects.requireNonNull(pTestVector);
        }

        public int hashCode() {
            return Objects.hash(this.argState, this.testVector);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof State) {
                State other = (State)pObj;
                return this.argState.equals(other.argState) && this.testVector.equals(other.testVector);
            }
            return false;
        }

        public String toString() {
            return "(" + this.argState + ", " + this.testVector + ")";
        }

        public static State of(ARGState pARGState, TestVector pTestVector) {
            return new State(pARGState, pTestVector);
        }
    }
}

