/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.harness;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;

public final class PredefinedTypes {
    private PredefinedTypes() {
    }

    public static boolean isPredefinedType(@Nullable CTypeDeclaration pDeclaration) {
        if (pDeclaration == null) {
            return false;
        }
        String originalName = pDeclaration.getOrigName();
        if (originalName == null) {
            return false;
        }
        return ImmutableSet.of((Object)"size_t", (Object)"wchar_t").contains((Object)originalName) || PredefinedTypes.isCalledDiv(originalName);
    }

    public static boolean isPredefinedFunction(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.isMalloc(pDeclaration) || PredefinedTypes.isMemcpy(pDeclaration) || PredefinedTypes.isMemset(pDeclaration) || PredefinedTypes.isFree(pDeclaration) || PredefinedTypes.isExit(pDeclaration) || PredefinedTypes.isAbort(pDeclaration) || PredefinedTypes.isPrintf(pDeclaration) || PredefinedTypes.isSwprintf(pDeclaration) || PredefinedTypes.isWcstombs(pDeclaration) || PredefinedTypes.isDiv(pDeclaration) || PredefinedTypes.isVerifierError(pDeclaration) || PredefinedTypes.isVerifierAssume(pDeclaration);
    }

    public static boolean isKnownTestFunction(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.isMalloc(pDeclaration) || PredefinedTypes.isCalloc(pDeclaration) || PredefinedTypes.isFree(pDeclaration) || PredefinedTypes.isExit(pDeclaration) || PredefinedTypes.isAbort(pDeclaration) || PredefinedTypes.isPrintf(pDeclaration) || PredefinedTypes.isVerifierError(pDeclaration) || PredefinedTypes.isVerifierAssume(pDeclaration);
    }

    public static boolean isPredefinedFunctionWithoutVerifierError(@Nullable AFunctionDeclaration pDeclaration) {
        return !PredefinedTypes.isVerifierError(pDeclaration) && PredefinedTypes.isPredefinedFunction(pDeclaration);
    }

    public static Type getCanonicalType(Type pType) {
        if (pType instanceof CType) {
            return ((CType)pType).getCanonicalType();
        }
        return pType;
    }

    private static boolean isMalloc(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "malloc", CPointerType.POINTER_TO_VOID, Collections.singletonList(PredefinedTypes::isIntegerType));
    }

    private static boolean isCalloc(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "calloc", CPointerType.POINTER_TO_VOID, (List<Predicate<Type>>)ImmutableList.of(PredefinedTypes::isIntegerType, PredefinedTypes::isIntegerType));
    }

    private static boolean isMemcpy(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "memcpy", CPointerType.POINTER_TO_VOID, (List<Predicate<Type>>)ImmutableList.of(Predicate.isEqual(CPointerType.POINTER_TO_VOID), Predicate.isEqual(new CPointerType(false, false, CVoidType.create(true, false))), PredefinedTypes::isIntegerType));
    }

    private static boolean isMemset(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "memset", CPointerType.POINTER_TO_VOID, (List<Predicate<Type>>)ImmutableList.of(Predicate.isEqual(CPointerType.POINTER_TO_VOID), PredefinedTypes::isIntegerType, PredefinedTypes::isIntegerType));
    }

    private static boolean isFree(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "free", CVoidType.VOID, Collections.singletonList(Predicate.isEqual(CPointerType.POINTER_TO_VOID)));
    }

    private static boolean isExit(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatches(pDeclaration, arg_0 -> ((ImmutableList)ImmutableList.of((Object)"exit", (Object)"_Exit")).contains(arg_0), Predicate.isEqual(CVoidType.VOID), Collections.singletonList(PredefinedTypes::isIntegerType));
    }

    private static boolean isAbort(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "abort", CVoidType.VOID, (List<Predicate<Type>>)ImmutableList.of());
    }

    private static boolean isPrintf(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "printf", CNumericTypes.INT, Collections.singletonList(Predicate.isEqual(new CPointerType(false, false, CNumericTypes.CHAR.getCanonicalType(true, false)))));
    }

    private static boolean isSwprintf(@Nullable AFunctionDeclaration pDeclaration) {
        Predicate<Type> isPointerToIntegral = t -> {
            Type type = PredefinedTypes.getCanonicalType(t);
            if (!(type instanceof CPointerType)) {
                return false;
            }
            return PredefinedTypes.isIntegerType(((CPointerType)type).getType());
        };
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "swprintf", CNumericTypes.INT, (List<Predicate<Type>>)ImmutableList.of(isPointerToIntegral, isPointerToIntegral));
    }

    private static boolean isWcstombs(@Nullable AFunctionDeclaration pDeclaration) {
        Predicate<Type> isPointerToIntegral = t -> {
            Type type = PredefinedTypes.getCanonicalType(t);
            if (!(type instanceof CPointerType)) {
                return false;
            }
            return PredefinedTypes.isIntegerType(((CPointerType)type).getType());
        };
        return PredefinedTypes.functionMatches(pDeclaration, "wcstombs", PredefinedTypes::isIntegerType, (List<Predicate<Type>>)ImmutableList.of(isPointerToIntegral, isPointerToIntegral, PredefinedTypes::isIntegerType));
    }

    private static boolean isDiv(@Nullable AFunctionDeclaration pDeclaration) {
        if (PredefinedTypes.functionMatches(pDeclaration, "div", PredefinedTypes::isDivType, (List<Predicate<Type>>)ImmutableList.of(Predicate.isEqual(CNumericTypes.INT), Predicate.isEqual(CNumericTypes.INT)))) {
            return true;
        }
        if (PredefinedTypes.functionMatches(pDeclaration, "ldiv", PredefinedTypes::isDivType, (List<Predicate<Type>>)ImmutableList.of(Predicate.isEqual(CNumericTypes.LONG_INT), Predicate.isEqual(CNumericTypes.LONG_INT)))) {
            return true;
        }
        return PredefinedTypes.functionMatches(pDeclaration, "lldiv", PredefinedTypes::isDivType, (List<Predicate<Type>>)ImmutableList.of(Predicate.isEqual(CNumericTypes.LONG_LONG_INT), Predicate.isEqual(CNumericTypes.LONG_LONG_INT)));
    }

    private static boolean isDivType(Type pType) {
        return PredefinedTypes.isCalledDiv(pType.toString().trim());
    }

    private static boolean isCalledDiv(String pTypeName) {
        return ImmutableList.of((Object)"div_t", (Object)"ldiv_t", (Object)"lldiv_t").contains((Object)pTypeName);
    }

    private static boolean isVerifierError(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "__VERIFIER_error", CVoidType.VOID, (List<Predicate<Type>>)ImmutableList.of());
    }

    public static boolean isVerifierAssume(@Nullable AFunctionDeclaration pDeclaration) {
        return PredefinedTypes.functionMatchesExactType(pDeclaration, "__VERIFIER_assume", CVoidType.VOID, (List<Predicate<Type>>)ImmutableList.of(PredefinedTypes::isIntegerType));
    }

    private static boolean isIntegerType(Type pType) {
        Type type = PredefinedTypes.getCanonicalType(pType);
        if (type instanceof JSimpleType) {
            return ((JSimpleType)type).getType().isIntegerType();
        }
        if (type instanceof CSimpleType) {
            return ((CSimpleType)type).getType().isIntegerType();
        }
        return false;
    }

    private static boolean functionMatchesExactType(@Nullable AFunctionDeclaration pDeclaration, String pExpectedName, Type pExpectedReturnType, List<Predicate<Type>> pExpectedParameterTypes) {
        return PredefinedTypes.functionMatches(pDeclaration, pExpectedName, Predicate.isEqual(PredefinedTypes.getCanonicalType(pExpectedReturnType)), pExpectedParameterTypes);
    }

    private static boolean functionMatches(@Nullable AFunctionDeclaration pDeclaration, String pExpectedName, Predicate<Type> pExpectedReturnType, List<Predicate<Type>> pExpectedParameterTypes) {
        return PredefinedTypes.functionMatches(pDeclaration, Predicate.isEqual(pExpectedName), pExpectedReturnType, pExpectedParameterTypes);
    }

    private static boolean functionMatches(@Nullable AFunctionDeclaration pDeclaration, Predicate<String> pExpectedName, Predicate<Type> pExpectedReturnType, List<Predicate<Type>> pExpectedParameterTypes) {
        if (pDeclaration == null) {
            return false;
        }
        if (!pExpectedName.test(pDeclaration.getOrigName())) {
            return false;
        }
        Type actualReturnType = pDeclaration.getType().getReturnType();
        if (!pExpectedReturnType.test(actualReturnType) && !pExpectedReturnType.test(PredefinedTypes.getCanonicalType(actualReturnType))) {
            return false;
        }
        if (pDeclaration.getParameters().size() != pExpectedParameterTypes.size()) {
            return false;
        }
        Iterator<Predicate<Type>> expectedParameterTypeIt = pExpectedParameterTypes.iterator();
        for (AParameterDeclaration aParameterDeclaration : pDeclaration.getParameters()) {
            Type actualParameterType = aParameterDeclaration.getType();
            Predicate<Type> expectedParameterType = expectedParameterTypeIt.next();
            if (expectedParameterType.test(actualParameterType) || expectedParameterType.test(PredefinedTypes.getCanonicalType(actualParameterType))) continue;
            return false;
        }
        return true;
    }
}

