/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.identifiers;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.Identifiers;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;

public final class BinaryIdentifier
implements AbstractIdentifier {
    final AbstractIdentifier id1;
    final AbstractIdentifier id2;
    final int dereference;

    public BinaryIdentifier(AbstractIdentifier i1, AbstractIdentifier i2, int deref) {
        this.id1 = i1;
        this.id2 = i2;
        this.dereference = deref;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dereference;
        result = 31 * result + Objects.hashCode(this.id1);
        result = 31 * result + Objects.hashCode(this.id2);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryIdentifier other = (BinaryIdentifier)obj;
        return this.dereference == other.dereference && Objects.equals(this.id1, other.id1) && Objects.equals(this.id2, other.id2);
    }

    @Override
    public String toString() {
        return Identifiers.getCharsOf(this.dereference) + "(" + this.id1 + " # " + this.id2 + ")";
    }

    @Override
    public boolean isGlobal() {
        return this.id1.isGlobal() || this.id2.isGlobal();
    }

    @Override
    public BinaryIdentifier cloneWithDereference(int pDereference) {
        return new BinaryIdentifier(this.id1, this.id2, pDereference);
    }

    public AbstractIdentifier getIdentifier1() {
        return this.id1;
    }

    public AbstractIdentifier getIdentifier2() {
        return this.id2;
    }

    @Override
    public int getDereference() {
        return this.dereference;
    }

    @Override
    public boolean isPointer() {
        return this.dereference != 0 || this.id1.isPointer() || this.id2.isPointer();
    }

    @Override
    public boolean isDereferenced() {
        return this.dereference != 0 || this.id1.isDereferenced() || this.id2.isDereferenced();
    }

    @Override
    public int compareTo(AbstractIdentifier pO) {
        if (pO instanceof SingleIdentifier) {
            return -1;
        }
        if (pO instanceof BinaryIdentifier) {
            int result = this.id1.compareTo(((BinaryIdentifier)pO).id1);
            return result != 0 ? result : this.id2.compareTo(((BinaryIdentifier)pO).id2);
        }
        return 1;
    }

    @Override
    public Collection<AbstractIdentifier> getComposedIdentifiers() {
        int deref = this.id1.getDereference();
        AbstractIdentifier tmp1 = this.id1.cloneWithDereference(this.dereference + deref);
        deref = this.id2.getDereference();
        AbstractIdentifier tmp2 = this.id2.cloneWithDereference(this.dereference + deref);
        HashSet result = Sets.newHashSet((Object[])new AbstractIdentifier[]{tmp1, tmp2});
        result.addAll(tmp1.getComposedIdentifiers());
        result.addAll(tmp2.getComposedIdentifiers());
        return result;
    }
}

