/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.identifiers;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.Identifiers;
import org.sosy_lab.cpachecker.util.identifiers.ReturnIdentifier;

public final class ConstantIdentifier
implements AbstractIdentifier {
    String name;
    int dereference;

    public ConstantIdentifier(String nm, int deref) {
        this.name = nm;
        this.dereference = deref;
    }

    @Override
    public ConstantIdentifier cloneWithDereference(int pDereference) {
        return new ConstantIdentifier(this.name, pDereference);
    }

    @Override
    public String toString() {
        Object info = Identifiers.getCharsOf(this.dereference);
        info = (String)info + this.name;
        return info;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public int getDereference() {
        return this.dereference;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dereference;
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantIdentifier other = (ConstantIdentifier)obj;
        return this.dereference == other.dereference && Objects.equals(this.name, other.name);
    }

    @Override
    public boolean isPointer() {
        return this.isDereferenced();
    }

    @Override
    public boolean isDereferenced() {
        return this.dereference > 0;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(AbstractIdentifier pO) {
        if (pO instanceof ReturnIdentifier) {
            return 1;
        }
        if (pO instanceof ConstantIdentifier) {
            return this.name.compareTo(((ConstantIdentifier)pO).name);
        }
        return -1;
    }

    @Override
    public Collection<AbstractIdentifier> getComposedIdentifiers() {
        return ImmutableSet.of();
    }
}

