/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.identifiers;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.BinaryIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.ConstantIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GlobalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.LocalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.StructureIdentifier;

public class IdentifierCreator
extends DefaultCExpressionVisitor<AbstractIdentifier, NoException> {
    protected int dereference;
    protected String function;

    public IdentifierCreator(String func) {
        this.function = func;
    }

    public static AbstractIdentifier createIdentifier(CSimpleDeclaration decl, String function, int dereference) {
        Preconditions.checkNotNull((Object)decl);
        String name = decl.getName();
        CType type = decl.getType();
        if (decl instanceof CDeclaration) {
            if (((CDeclaration)decl).isGlobal()) {
                return new GlobalVariableIdentifier(name, type, dereference);
            }
            return new LocalVariableIdentifier(name, type, function, dereference);
        }
        if (decl instanceof CParameterDeclaration) {
            return new LocalVariableIdentifier(name, type, function, dereference);
        }
        if (decl instanceof CEnumType.CEnumerator) {
            return new ConstantIdentifier(name, dereference);
        }
        return null;
    }

    public AbstractIdentifier createIdentifier(CExpression expression, int pDereference) {
        Preconditions.checkNotNull((Object)expression);
        this.dereference = pDereference;
        return expression.accept(this);
    }

    @Override
    public AbstractIdentifier visit(CArraySubscriptExpression expression) {
        ++this.dereference;
        return expression.getArrayExpression().accept(this);
    }

    @Override
    public AbstractIdentifier visit(CBinaryExpression expression) {
        int oldDereference = this.dereference;
        this.dereference = 0;
        AbstractIdentifier resultId1 = expression.getOperand1().accept(this);
        this.dereference = 0;
        AbstractIdentifier resultId2 = expression.getOperand2().accept(this);
        BinaryIdentifier result = new BinaryIdentifier(resultId1, resultId2, oldDereference);
        this.dereference = oldDereference;
        return result;
    }

    @Override
    public AbstractIdentifier visit(CCastExpression expression) {
        return expression.getOperand().accept(this);
    }

    @Override
    public AbstractIdentifier visit(CFieldReference expression) {
        CExpression owner = expression.getFieldOwner();
        int oldDeref = this.dereference;
        this.dereference = expression.isPointerDereference() ? 1 : 0;
        AbstractIdentifier ownerId = owner.accept(this);
        this.dereference = oldDeref;
        StructureIdentifier fullId = new StructureIdentifier(expression.getFieldName(), expression.getExpressionType(), this.dereference, ownerId);
        return fullId;
    }

    @Override
    public AbstractIdentifier visit(CIdExpression expression) {
        CSimpleDeclaration decl = expression.getDeclaration();
        if (decl == null) {
            return new LocalVariableIdentifier(expression.getName(), expression.getExpressionType(), this.function, this.dereference);
        }
        return IdentifierCreator.createIdentifier(decl, this.function, this.dereference);
    }

    @Override
    public AbstractIdentifier visit(CUnaryExpression expression) {
        AbstractIdentifier result;
        if (expression.getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
            --this.dereference;
        }
        if ((result = expression.getOperand().accept(this)) instanceof BinaryIdentifier) {
            return this.getMainPart((BinaryIdentifier)result);
        }
        return result;
    }

    @Override
    public AbstractIdentifier visit(CPointerExpression pPointerExpression) {
        ++this.dereference;
        AbstractIdentifier result = pPointerExpression.getOperand().accept(this);
        if (result instanceof BinaryIdentifier) {
            return this.getMainPart((BinaryIdentifier)result);
        }
        return result;
    }

    private AbstractIdentifier getMainPart(BinaryIdentifier id) {
        AbstractIdentifier id1 = id.getIdentifier1();
        AbstractIdentifier id2 = id.getIdentifier2();
        AbstractIdentifier main = null;
        if (id1 instanceof SingleIdentifier && id2 instanceof ConstantIdentifier) {
            main = id1;
        } else if (id2 instanceof SingleIdentifier && id1 instanceof ConstantIdentifier) {
            main = id2;
        } else if (id1 instanceof SingleIdentifier && id2 instanceof SingleIdentifier) {
            SingleIdentifier s1 = (SingleIdentifier)id1;
            SingleIdentifier s2 = (SingleIdentifier)id2;
            if (s1.isPointer() && !s2.isPointer()) {
                main = s1;
            } else if (s1.isPointer() && !s2.isPointer()) {
                main = s2;
            } else if (s1.getType().getClass() == CSimpleType.class && s2.getType().getClass() != CSimpleType.class) {
                main = s2;
            } else if (s2.getType().getClass() == CSimpleType.class && s1.getType().getClass() != CSimpleType.class) {
                main = s1;
            }
        }
        if (main != null) {
            return main.cloneWithDereference(main.getDereference() + id.getDereference());
        }
        return id;
    }

    @Override
    public AbstractIdentifier visit(CComplexCastExpression pComplexCastExpression) {
        return pComplexCastExpression.getOperand().accept(this);
    }

    @Override
    protected AbstractIdentifier visitDefault(CExpression pExp) {
        return new ConstantIdentifier(pExp.toASTString(), this.dereference);
    }
}

