/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.identifiers;

import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.IdentifierCreator;

public class Identifiers {
    public static Collection<AbstractIdentifier> getDereferencedIdentifiers(AbstractIdentifier id) {
        HashSet<AbstractIdentifier> result = new HashSet<AbstractIdentifier>();
        for (int d = id.getDereference(); d >= 0; --d) {
            result.add(id.cloneWithDereference(d));
        }
        return result;
    }

    static String getCharsOf(int dereference) {
        StringBuilder info = new StringBuilder();
        if (dereference > 0) {
            for (int i = 0; i < dereference; ++i) {
                info.append("*");
            }
        } else if (dereference == -1) {
            info.append("&");
        } else if (dereference < -1) {
            info.append("Error in string representation, dereference < -1");
        }
        return info.toString();
    }

    public static AbstractIdentifier createIdentifier(CExpression expression, String function) {
        return Identifiers.createIdentifier(expression, 0, function);
    }

    public static AbstractIdentifier createIdentifier(CExpression expression, int dereference, String function) {
        IdentifierCreator idCreator = new IdentifierCreator(function);
        return idCreator.createIdentifier(expression, dereference);
    }
}

