/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.identifiers;

import com.google.common.base.Strings;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralLocalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GlobalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.VariableIdentifier;

public class LocalVariableIdentifier
extends VariableIdentifier {
    protected @NonNull String function;

    public LocalVariableIdentifier(String nm, CType t, String func, int dereference) {
        super(nm, t, dereference);
        this.function = Strings.nullToEmpty((String)func);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.function);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalVariableIdentifier other = (LocalVariableIdentifier)obj;
        return Objects.equals(this.function, other.function);
    }

    @Override
    public LocalVariableIdentifier cloneWithDereference(int pDereference) {
        return new LocalVariableIdentifier(this.name, this.type, this.function, pDereference);
    }

    public String getFunction() {
        return this.function;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public String toLog() {
        return "l;" + this.name + ";" + this.dereference;
    }

    @Override
    public GeneralIdentifier getGeneralId() {
        return new GeneralLocalVariableIdentifier(this.name, this.type, this.function, this.dereference);
    }

    @Override
    public int compareTo(AbstractIdentifier pO) {
        if (pO instanceof LocalVariableIdentifier) {
            int result = super.compareTo(pO);
            if (result != 0) {
                return result;
            }
            return this.function.compareTo(((LocalVariableIdentifier)pO).function);
        }
        if (pO instanceof GlobalVariableIdentifier) {
            return -1;
        }
        return 1;
    }
}

