/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.identifiers;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.local.LocalTransferRelation;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.Identifiers;

public abstract class SingleIdentifier
implements AbstractIdentifier {
    protected String name;
    protected CType type;
    protected int dereference;

    protected SingleIdentifier(String nm, CType tp, int deref) {
        this.name = nm;
        this.type = tp;
        this.dereference = deref;
    }

    @Override
    public int getDereference() {
        return this.dereference;
    }

    public CType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPointer() {
        return LocalTransferRelation.findDereference(this.type) > 0;
    }

    @Override
    public boolean isDereferenced() {
        return this.dereference > 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dereference;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + (this.type == null ? 0 : this.type.toASTString("").hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleIdentifier other = (SingleIdentifier)obj;
        return this.dereference == other.dereference && Objects.equals(this.name, other.name) && Objects.equals(this.type.toASTString(""), other.type.toASTString(""));
    }

    @Override
    public String toString() {
        Object info = Identifiers.getCharsOf(this.dereference);
        info = (String)info + this.name;
        return info;
    }

    public abstract String toLog();

    public abstract GeneralIdentifier getGeneralId();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(AbstractIdentifier pO) {
        if (!(pO instanceof SingleIdentifier)) {
            return 1;
        }
        SingleIdentifier other = (SingleIdentifier)pO;
        int result = this.name.compareTo(other.name);
        if (result != 0) {
            return result;
        }
        if (this.type != null) {
            if (other.type == null) return 1;
            result = this.type.toASTString("").compareTo(other.type.toASTString(""));
            if (result == 0) return this.dereference - other.dereference;
            return result;
        }
        if (other.type == null) return this.dereference - other.dereference;
        return -1;
    }
}

