/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.identifiers;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralStructureFieldIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GlobalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.Identifiers;
import org.sosy_lab.cpachecker.util.identifiers.LocalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.StructureIdentifier;

public class StructureFieldIdentifier
extends StructureIdentifier {
    public StructureFieldIdentifier(String pNm, CType pTp, int dereference, AbstractIdentifier own) {
        super(pNm, pTp, dereference, own);
    }

    @Override
    public String toString() {
        return Identifiers.getCharsOf(this.dereference) + "(?." + this.name + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        StructureFieldIdentifier other = (StructureFieldIdentifier)obj;
        return Objects.equals(this.type, other.type);
    }

    @Override
    public StructureFieldIdentifier cloneWithDereference(int deref) {
        return new StructureFieldIdentifier(this.name, this.type, deref, this.owner);
    }

    @Override
    public Collection<AbstractIdentifier> getComposedIdentifiers() {
        return ImmutableSet.of();
    }

    @Override
    public String toLog() {
        return "f;" + this.name + ";" + this.dereference;
    }

    @Override
    public GeneralIdentifier getGeneralId() {
        return new GeneralStructureFieldIdentifier(this.name, this.type, this.dereference, this.owner);
    }

    @Override
    public int compareTo(AbstractIdentifier pO) {
        if (pO instanceof GlobalVariableIdentifier || pO instanceof LocalVariableIdentifier) {
            return -1;
        }
        if (pO instanceof StructureFieldIdentifier) {
            return super.compareTo(pO);
        }
        return 1;
    }
}

