/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.identifiers;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralStructureFieldIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.Identifiers;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.StructureFieldIdentifier;

public class StructureIdentifier
extends SingleIdentifier {
    protected AbstractIdentifier owner;

    public StructureIdentifier(String pNm, CType pTp, int dereference, AbstractIdentifier own) {
        super(pNm, pTp, dereference);
        this.owner = own;
    }

    @Override
    public String toString() {
        return Identifiers.getCharsOf(this.dereference) + "((" + this.owner + ")." + this.name + ")";
    }

    @Override
    public StructureIdentifier cloneWithDereference(int pDereference) {
        return new StructureIdentifier(this.name, this.type, pDereference, this.owner);
    }

    public AbstractIdentifier getOwner() {
        return this.owner;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.owner);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        StructureIdentifier other = (StructureIdentifier)obj;
        return Objects.equals(this.owner, other.owner);
    }

    @Override
    public boolean isGlobal() {
        return this.owner.isGlobal();
    }

    @Override
    public boolean isDereferenced() {
        if (super.isDereferenced()) {
            return true;
        }
        return this.owner.isDereferenced();
    }

    @Override
    public String toLog() {
        return "s;" + this.name + ";" + this.dereference;
    }

    @Override
    public GeneralIdentifier getGeneralId() {
        return new GeneralStructureFieldIdentifier(this.name, this.type, this.dereference, this.owner);
    }

    public StructureFieldIdentifier toStructureFieldIdentifier() {
        if (this.owner instanceof SingleIdentifier) {
            return new StructureFieldIdentifier(this.name, ((SingleIdentifier)this.owner).type, this.dereference, null);
        }
        return new StructureFieldIdentifier(this.name, this.type, this.dereference, null);
    }

    @Override
    public Collection<AbstractIdentifier> getComposedIdentifiers() {
        HashSet result = Sets.newHashSet((Object[])new AbstractIdentifier[]{this.owner});
        result.addAll(this.owner.getComposedIdentifiers());
        return result;
    }
}

