/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;

public class InvariantWitness {
    private final ExpressionTree<Object> formula;
    private final CFANode node;
    private final FileLocation location;

    InvariantWitness(ExpressionTree<Object> pFormula, FileLocation pLocation, CFANode pNode) {
        this.formula = Objects.requireNonNull(pFormula);
        this.node = Objects.requireNonNull(pNode);
        this.location = Objects.requireNonNull(pLocation);
    }

    public FileLocation getLocation() {
        return this.location;
    }

    public CFANode getNode() {
        return this.node;
    }

    public ExpressionTree<Object> getFormula() {
        return this.formula;
    }

    public int hashCode() {
        int hashCode = this.location.hashCode();
        hashCode = 31 * hashCode + this.formula.hashCode();
        hashCode = 31 * hashCode + this.node.hashCode();
        return hashCode;
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (!(pObj instanceof InvariantWitness)) {
            return false;
        }
        InvariantWitness other = (InvariantWitness)pObj;
        return other.formula.equals(this.formula) && other.location.equals(this.location) && other.node.equals(this.node);
    }

    public String toString() {
        return this.formula.toString();
    }
}

