/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitness;

public class InvariantWitnessFactory {
    private final LogManager logger;
    private final CFA cfa;

    private InvariantWitnessFactory(LogManager pLogger, CFA pCfa) {
        this.logger = pLogger;
        this.cfa = pCfa;
    }

    public static InvariantWitnessFactory getFactory(LogManager pLogger, CFA pCFA) {
        return new InvariantWitnessFactory(pLogger, pCFA);
    }

    public Collection<InvariantWitness> fromNodeAndInvariant(CFANode node, ExpressionTree<Object> invariant) {
        Set<FileLocation> effectiveLocations = this.getEffectiveLocations(node);
        ImmutableSet.Builder result = ImmutableSet.builder();
        if (effectiveLocations.isEmpty()) {
            this.logger.logf(Level.FINEST, "Could not determine a location for invariant %s, skipping.", new Object[]{invariant});
        }
        for (FileLocation invariantLocation : effectiveLocations) {
            InvariantWitness invariantWitness = new InvariantWitness(invariant, invariantLocation, node);
            result.add((Object)invariantWitness);
        }
        return result.build();
    }

    public InvariantWitness fromLocationAndInvariant(FileLocation fileLocation, CFANode node, ExpressionTree<Object> invariant) {
        return new InvariantWitness(invariant, fileLocation, node);
    }

    private Set<FileLocation> getEffectiveLocations(CFANode node) {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        if (node instanceof FunctionEntryNode || node instanceof FunctionExitNode) {
            return locations.build();
        }
        for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
            if (edge.getFileLocation().equals(FileLocation.DUMMY) || edge.getDescription().contains("CPAchecker_TMP") || edge instanceof AssumeEdge) continue;
            locations.add((Object)edge.getFileLocation());
        }
        return locations.build();
    }
}

