/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.invariants.AbstractInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.expressions.DownwardCastingVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.ToFormulaVisitor;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitness;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.entryimport.InvariantWitnessProvider;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class InvariantWitnessGenerator
extends AbstractInvariantGenerator
implements AutoCloseable {
    private final InvariantWitnessProvider provider;
    private final LogManager logger;

    private InvariantWitnessGenerator(LogManager pLogger, InvariantWitnessProvider pProvider) {
        this.provider = pProvider;
        this.logger = pLogger;
    }

    public static InvariantWitnessGenerator getNewFromDiskInvariantGenerator(Configuration pConfig, CFA pCFA, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException, IOException {
        InvariantWitnessProvider provider = InvariantWitnessProvider.getNewFromDiskWitnessProvider(pConfig, pCFA, pLogger, pShutdownNotifier);
        return new InvariantWitnessGenerator(pLogger, provider);
    }

    @Override
    public InvariantSupplier getSupplier() throws CPAException, InterruptedException {
        try {
            return new InvariantSupplier(){
                private final Map<CFANode, ExpressionTree<Object>> witnessesByNode;
                private final DownwardCastingVisitor<Object, AExpression> caster;
                {
                    this.witnessesByNode = InvariantWitnessGenerator.this.getCurrentWitnessesByNodes();
                    this.caster = new DownwardCastingVisitor(AExpression.class);
                }

                @Override
                public BooleanFormula getInvariantFor(CFANode pNode, Optional<CallstackStateEqualsWrapper> pCallstackInformation, FormulaManagerView pFmgr, PathFormulaManager pPfmgr, @Nullable PathFormula pContext) throws InterruptedException {
                    ExpressionTree invariant = this.witnessesByNode.getOrDefault(pNode, ExpressionTrees.getTrue());
                    ToFormulaVisitor visitor = new ToFormulaVisitor(pFmgr, pPfmgr, pContext);
                    try {
                        return ((ExpressionTree)invariant.accept(this.caster)).accept(visitor);
                    }
                    catch (ToFormulaVisitor.ToFormulaException e) {
                        InvariantWitnessGenerator.this.logger.logDebugException((Throwable)e);
                    }
                    catch (DownwardCastingVisitor.IncompatibleLeafTypesException e) {
                        throw new AssertionError((Object)e);
                    }
                    return pFmgr.getBooleanFormulaManager().makeTrue();
                }
            };
        }
        catch (IOException e) {
            throw new CPAException("Could not load invariants from disk", e);
        }
    }

    @Override
    public ExpressionTreeSupplier getExpressionTreeSupplier() throws CPAException, InterruptedException {
        try {
            return new ExpressionTreeSupplier(){
                private final Map<CFANode, ExpressionTree<Object>> witnessesByNode;
                {
                    this.witnessesByNode = InvariantWitnessGenerator.this.getCurrentWitnessesByNodes();
                }

                @Override
                public ExpressionTree<Object> getInvariantFor(CFANode pNode) {
                    return ExpressionTrees.cast(this.witnessesByNode.getOrDefault(pNode, ExpressionTrees.getTrue()));
                }
            };
        }
        catch (IOException e) {
            throw new CPAException("Could not load invariants from disk", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.provider.close();
    }

    private Map<CFANode, ExpressionTree<Object>> getCurrentWitnessesByNodes() throws InterruptedException, IOException {
        ExpressionTreeFactory factory = ExpressionTrees.newFactory();
        Collection<InvariantWitness> witnesses = this.provider.getCurrentWitnesses();
        return (Map)witnesses.stream().collect(ImmutableMap.toImmutableMap(InvariantWitness::getNode, InvariantWitness::getFormula, factory::or));
    }

    @Override
    protected void startImpl(CFANode pInitialLocation) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isProgramSafe() {
        return false;
    }
}

