/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness.exchange;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class InvariantStoreUtil {
    public static ListMultimap<String, Integer> getLineOffsetsByFile(Collection<Path> filePaths) throws IOException {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Path filePath : filePaths) {
            if (!Files.isRegularFile(filePath, new LinkOption[0])) continue;
            String fileContent = Files.readString(filePath);
            int currentOffset = 0;
            List sourceLines = Splitter.onPattern((String)"\\n").splitToList((CharSequence)fileContent);
            for (String sourceLine : sourceLines) {
                result.put((Object)filePath.toString(), (Object)currentOffset);
                currentOffset += sourceLine.length() + 1;
            }
        }
        return result.build();
    }

    public static Collection<CFANode> getNodesAtFileLocation(FileLocation fileLocation, CFA cfa) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (CFANode candidate : cfa.getAllNodes()) {
            if (candidate instanceof FunctionEntryNode || candidate instanceof FunctionExitNode || !InvariantStoreUtil.nodeMatchesFileLocation(candidate, fileLocation)) continue;
            result.add((Object)candidate);
        }
        return result.build();
    }

    private static boolean nodeMatchesFileLocation(CFANode node, FileLocation fileLocation) {
        boolean existsEdgeBefore = CFAUtils.enteringEdges(node).filter(edge -> !edge.getFileLocation().equals(FileLocation.DUMMY)).anyMatch(edge -> edge.getFileLocation().getNodeOffset() <= fileLocation.getNodeOffset());
        boolean existsEdgeAfter = CFAUtils.leavingEdges(node).filter(edge -> !edge.getFileLocation().equals(FileLocation.DUMMY)).anyMatch(edge -> edge.getFileLocation().getNodeOffset() >= fileLocation.getNodeOffset());
        return existsEdgeBefore && existsEdgeAfter;
    }
}

