/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness.exchange;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitness;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.InvariantStoreUtil;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.LoopInvariantEntry;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.InformationRecord;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.LocationRecord;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.MetadataRecord;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.ProducerRecord;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.TaskRecord;

@Options(prefix="invariantStore.export")
public final class InvariantWitnessWriter {
    private final ListMultimap<String, Integer> lineOffsetsByFile;
    private final LogManager logger;
    private final ObjectMapper mapper;
    private final ProducerRecord producerDescription;
    private final TaskRecord taskDescription;
    @Option(secure=true, description="The directory where the invariants are stored.")
    @FileOption(value=FileOption.Type.OUTPUT_DIRECTORY)
    private Path outDir = Path.of("invariantWitnesses", new String[0]);

    private InvariantWitnessWriter(Configuration pConfig, LogManager pLogger, ListMultimap<String, Integer> pLineOffsetsByFile, ProducerRecord pProducerDescription, TaskRecord pTaskDescription) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = Objects.requireNonNull(pLogger);
        this.lineOffsetsByFile = ArrayListMultimap.create(pLineOffsetsByFile);
        this.mapper = new ObjectMapper((JsonFactory)YAMLFactory.builder().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, new YAMLGenerator.Feature[]{YAMLGenerator.Feature.SPLIT_LINES}).build());
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.producerDescription = pProducerDescription;
        this.taskDescription = pTaskDescription;
    }

    public static InvariantWitnessWriter getWriter(Configuration pConfig, CFA pCFA, Specification pSpecification, LogManager pLogger) throws InvalidConfigurationException, IOException {
        if (pSpecification.getProperties().size() != 1) {
            throw new InvalidConfigurationException("Invariant export only supported for specific verificaiton task");
        }
        return new InvariantWitnessWriter(pConfig, pLogger, InvariantStoreUtil.getLineOffsetsByFile(pCFA.getFileNames()), new ProducerRecord("CPAchecker", CPAchecker.getPlainVersion(), CPAchecker.getApproachName(pConfig), null, null), InvariantWitnessWriter.getTaskDescription(pCFA, pSpecification));
    }

    private static TaskRecord getTaskDescription(CFA pCFA, Specification pSpecification) throws IOException {
        List<Path> inputFiles = pCFA.getFileNames();
        ImmutableMap.Builder inputFileHashes = ImmutableMap.builder();
        for (Path inputFile : inputFiles) {
            inputFileHashes.put((Object)inputFile.toString(), (Object)AutomatonGraphmlCommon.computeHash(inputFile));
        }
        String specification = pSpecification.getProperties().iterator().next().toString();
        return new TaskRecord((List)inputFiles.stream().map(Path::toString).collect(ImmutableList.toImmutableList()), (Map<String, String>)inputFileHashes.buildOrThrow(), specification, InvariantWitnessWriter.getArchitecture(pCFA.getMachineModel()), pCFA.getLanguage().toString());
    }

    private static String getArchitecture(MachineModel pMachineModel) {
        String architecture;
        switch (pMachineModel) {
            case LINUX32: {
                architecture = "ILP32";
                break;
            }
            case LINUX64: {
                architecture = "LP64";
                break;
            }
            default: {
                architecture = pMachineModel.toString();
            }
        }
        return architecture;
    }

    public void exportInvariantWitness(InvariantWitness invariantWitness) throws IOException {
        LoopInvariantEntry entry = this.invariantWitnessToStoreEnty(invariantWitness);
        String entryYaml = this.mapper.writeValueAsString((Object)ImmutableList.of((Object)entry));
        Path outFile = this.outDir.resolve(entry.getMetadata().getUuid() + ".invariantwitness.yaml");
        this.logger.log(Level.INFO, new Object[]{"Exporting invariant", outFile});
        try (Writer writer = IO.openOutputFile((Path)outFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            writer.write(entryYaml);
        }
    }

    private LoopInvariantEntry invariantWitnessToStoreEnty(InvariantWitness invariantWitness) {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault()).withNano(0);
        String creationTime = now.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        MetadataRecord metadata = new MetadataRecord("0.1", UUID.randomUUID().toString(), creationTime, this.producerDescription, this.taskDescription);
        String fileName = invariantWitness.getLocation().getFileName().toString();
        int lineNumber = invariantWitness.getLocation().getStartingLineInOrigin();
        int lineOffset = (Integer)this.lineOffsetsByFile.get((Object)fileName).get(lineNumber - 1);
        int offsetInLine = invariantWitness.getLocation().getNodeOffset() - lineOffset;
        LocationRecord location = new LocationRecord(fileName, "file_hash", lineNumber, offsetInLine, invariantWitness.getNode().getFunctionName());
        InformationRecord invariant = new InformationRecord(invariantWitness.getFormula().toString(), "assertion", "C");
        LoopInvariantEntry entry = new LoopInvariantEntry("loop_invariant", metadata, location, invariant);
        return entry;
    }
}

