/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness.exchange.entryimport;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.FluentIterable;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.AbstractEntry;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.LoopInvariantEntry;

@Options(prefix="invariantStore.import")
class FromDiskEntryProvider
implements AutoCloseable {
    @Option(secure=true, description="The directory where the invariants are stored.")
    @FileOption(value=FileOption.Type.OUTPUT_DIRECTORY)
    private Path storeDirectory = Path.of("invariantWitnesses", new String[0]);
    private final Queue<LoopInvariantEntry> loadedEntries;
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final JavaType entryType;
    private WatchService watchService;

    private FromDiskEntryProvider(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.loadedEntries = new ArrayDeque<LoopInvariantEntry>();
        this.entryType = this.mapper.getTypeFactory().constructCollectionType(List.class, AbstractEntry.class);
    }

    static FromDiskEntryProvider getNewFromDiskEntryProvider(Configuration pConfig) throws InvalidConfigurationException {
        return new FromDiskEntryProvider(pConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<LoopInvariantEntry> getNext() throws IOException {
        FromDiskEntryProvider fromDiskEntryProvider = this;
        synchronized (fromDiskEntryProvider) {
            if (!this.loadedEntries.isEmpty()) {
                return Optional.of(this.loadedEntries.remove());
            }
        }
        WatchKey key = this.getWatchService().poll();
        if (key == null) {
            return Optional.empty();
        }
        this.loadEntriesFromWatchKey(key);
        return this.getNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoopInvariantEntry awaitNext() throws InterruptedException, IOException {
        FromDiskEntryProvider fromDiskEntryProvider = this;
        synchronized (fromDiskEntryProvider) {
            if (!this.loadedEntries.isEmpty()) {
                return this.loadedEntries.remove();
            }
        }
        WatchKey key = this.getWatchService().take();
        this.loadEntriesFromWatchKey(key);
        return this.awaitNext();
    }

    private synchronized void loadEntriesFromWatchKey(WatchKey key) throws IOException {
        for (WatchEvent<?> event : key.pollEvents()) {
            if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
            Path newFilePath = (Path)event.context();
            File newFile = this.storeDirectory.resolve(newFilePath).toFile();
            this.loadEntries(newFile);
        }
        key.reset();
    }

    private synchronized WatchService getWatchService() {
        return this.watchService;
    }

    synchronized void start() throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.storeDirectory.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.storeDirectory, p -> p.toFile().isFile());){
            for (Path file : stream) {
                this.loadEntries(file.toFile());
            }
        }
    }

    private synchronized void loadEntries(File entriesFile) throws IOException {
        List entries = (List)this.mapper.readValue(entriesFile, this.entryType);
        FluentIterable.from((Iterable)entries).filter(LoopInvariantEntry.class).copyInto(this.loadedEntries);
    }

    @Override
    public void close() throws IOException {
        this.getWatchService().close();
    }
}

