/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness.exchange.entryimport;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.util.CParserUtils;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitness;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitnessFactory;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.InvariantStoreUtil;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.LoopInvariantEntry;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.LocationRecord;

class InvariantStoreEntryParser {
    private final ListMultimap<String, Integer> lineOffsetsByFile;
    private final LogManager logger;
    private final InvariantWitnessFactory invariantWitnessFactory;
    private final CParser parser;
    private final CProgramScope scope;
    private final CParserUtils.ParserTools parserTools;
    private final CFA cfa;

    private InvariantStoreEntryParser(ListMultimap<String, Integer> pLineOffsetsByFile, LogManager pLogger, InvariantWitnessFactory pInvariantWitnessFactory, CParser pParser, CProgramScope pScope, CParserUtils.ParserTools pParserTools, CFA pCfa) {
        this.lineOffsetsByFile = ArrayListMultimap.create(pLineOffsetsByFile);
        this.logger = Objects.requireNonNull(pLogger);
        this.invariantWitnessFactory = Objects.requireNonNull(pInvariantWitnessFactory);
        this.parser = Objects.requireNonNull(pParser);
        this.scope = Objects.requireNonNull(pScope);
        this.parserTools = Objects.requireNonNull(pParserTools);
        this.cfa = Objects.requireNonNull(pCfa);
    }

    static InvariantStoreEntryParser getNewInvariantStoreEntryParser(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCFA, ListMultimap<String, Integer> pLineOffsetsByFile) throws InvalidConfigurationException {
        InvariantWitnessFactory invariantWitnessFactory = InvariantWitnessFactory.getFactory(pLogger, pCFA);
        CProgramScope scope = new CProgramScope(pCFA, pLogger);
        CParserUtils.ParserTools parserTools = CParserUtils.ParserTools.create(ExpressionTrees.newFactory(), pCFA.getMachineModel(), pLogger);
        CParser parser = CParser.Factory.getParser(pLogger, CParser.Factory.getOptions(pConfig), pCFA.getMachineModel(), pShutdownNotifier);
        return new InvariantStoreEntryParser(pLineOffsetsByFile, pLogger, invariantWitnessFactory, parser, scope, parserTools, pCFA);
    }

    Collection<InvariantWitness> parseStoreEntry(LoopInvariantEntry entry) throws InterruptedException {
        LocationRecord location = entry.getLocation();
        if (!this.lineOffsetsByFile.containsKey((Object)location.getFileName())) {
            this.logger.log(Level.INFO, new Object[]{"Invariant", entry.getLoopInvariant(), "does not apply to any input file"});
            return ImmutableSet.of();
        }
        FileLocation fileLocation = this.parseFileLocation(location);
        Collection<CFANode> candidateNodes = InvariantStoreUtil.getNodesAtFileLocation(fileLocation, this.cfa);
        CProgramScope functionScope = this.scope.withFunctionScope(location.getFunction());
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (CFANode candidateNode : candidateNodes) {
            CProgramScope scopeWithPredicate = functionScope.withLocationDescriptor(InvariantStoreEntryParser.getNodeScopeDescriptor(candidateNode));
            ExpressionTree<AExpression> invariantFormula = CParserUtils.parseStatementsAsExpressionTree((Set<String>)ImmutableSet.of((Object)entry.getLoopInvariant().getString()), Optional.empty(), this.parser, scopeWithPredicate, this.parserTools);
            if (invariantFormula.equals(ExpressionTrees.getTrue())) continue;
            result.add((Object)this.invariantWitnessFactory.fromLocationAndInvariant(fileLocation, candidateNode, ExpressionTrees.cast(invariantFormula)));
        }
        return result.build();
    }

    private static Predicate<FileLocation> getNodeScopeDescriptor(CFANode node) {
        Collection<FileLocation> possiblyUsageLocations = InvariantStoreEntryParser.tryFindUsageLocations(node);
        int minOffset = possiblyUsageLocations.stream().map(f -> f.getNodeOffset()).min(Integer::compare).orElse(0);
        int maxOffset = possiblyUsageLocations.stream().map(f -> f.getNodeOffset()).max(Integer::compare).orElse(0);
        return f -> minOffset <= f.getNodeOffset() && f.getNodeOffset() <= maxOffset;
    }

    private static Collection<FileLocation> tryFindUsageLocations(CFANode rootNode) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        HashSet<CFANode> visited = new HashSet<CFANode>();
        waitlist.add(rootNode);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.remove();
            if (visited.contains(current)) continue;
            visited.add(current);
            for (int leavingEdgeId = 0; leavingEdgeId < current.getNumLeavingEdges(); ++leavingEdgeId) {
                CFAEdge leavingEdge = current.getLeavingEdge(leavingEdgeId);
                if (leavingEdge instanceof FunctionReturnEdge || leavingEdge instanceof FunctionCallEdge) continue;
                if (!leavingEdge.getFileLocation().equals(FileLocation.DUMMY)) {
                    result.add((Object)leavingEdge.getFileLocation());
                }
                if (leavingEdge.getSuccessor().getReversePostorderId() >= current.getReversePostorderId()) continue;
                waitlist.add(leavingEdge.getSuccessor());
            }
        }
        return result.build();
    }

    private FileLocation parseFileLocation(LocationRecord entryLocation) {
        int offetInFile = (Integer)this.lineOffsetsByFile.get((Object)entryLocation.getFileName()).get(entryLocation.getLine() - 1);
        return new FileLocation(Path.of(entryLocation.getFileName(), new String[0]), offetInFile + entryLocation.getColumn(), 0, entryLocation.getLine(), entryLocation.getLine());
    }
}

