/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness.exchange.entryimport;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitness;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.InvariantStoreUtil;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.entryimport.FromDiskEntryProvider;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.entryimport.InvariantStoreEntryParser;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.LoopInvariantEntry;

public final class InvariantWitnessProvider
implements AutoCloseable {
    private final InvariantStoreEntryParser parser;
    private final FromDiskEntryProvider entryProvider;
    private final Set<InvariantWitness> knownWitnesses;

    private InvariantWitnessProvider(InvariantStoreEntryParser pParser, FromDiskEntryProvider pEntryProvider) {
        this.parser = Objects.requireNonNull(pParser);
        this.entryProvider = Objects.requireNonNull(pEntryProvider);
        this.knownWitnesses = ConcurrentHashMap.newKeySet();
    }

    public static InvariantWitnessProvider getNewFromDiskWitnessProvider(Configuration pConfig, CFA pCFA, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException, IOException {
        ListMultimap<String, Integer> lineOffsetsByFile = InvariantStoreUtil.getLineOffsetsByFile(pCFA.getFileNames());
        FromDiskEntryProvider entryProvider = FromDiskEntryProvider.getNewFromDiskEntryProvider(pConfig);
        entryProvider.start();
        return new InvariantWitnessProvider(InvariantStoreEntryParser.getNewInvariantStoreEntryParser(pConfig, pLogger, pShutdownNotifier, pCFA, lineOffsetsByFile), entryProvider);
    }

    public synchronized Collection<InvariantWitness> getCurrentWitnesses() throws InterruptedException, IOException {
        ImmutableSet.Builder newWitnesses = ImmutableSet.builder();
        Optional<LoopInvariantEntry> newEntry = this.entryProvider.getNext();
        while (newEntry.isPresent()) {
            newWitnesses.addAll(this.parser.parseStoreEntry(newEntry.orElseThrow()));
            newEntry = this.entryProvider.getNext();
        }
        this.knownWitnesses.addAll((Collection<InvariantWitness>)newWitnesses.build());
        return ImmutableSet.copyOf(this.knownWitnesses);
    }

    @Override
    public void close() throws IOException {
        this.entryProvider.close();
    }
}

