/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness.exchange.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.AbstractEntry;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.InformationRecord;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.LocationRecord;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common.MetadataRecord;

@Immutable
public class LoopInvariantEntry
extends AbstractEntry {
    @JsonProperty(value="metadata")
    private final MetadataRecord metadata;
    @JsonProperty(value="location")
    private final LocationRecord location;
    @JsonProperty(value="loop_invariant")
    private final InformationRecord loopInvariant;

    public LoopInvariantEntry(@JsonProperty(value="entry_type") String entryType, @JsonProperty(value="metadata") MetadataRecord metadata, @JsonProperty(value="location") LocationRecord location, @JsonProperty(value="loop_invariant") InformationRecord loopInvariant) {
        super(entryType);
        this.metadata = metadata;
        this.location = location;
        this.loopInvariant = loopInvariant;
    }

    public MetadataRecord getMetadata() {
        return this.metadata;
    }

    public LocationRecord getLocation() {
        return this.location;
    }

    public InformationRecord getLoopInvariant() {
        return this.loopInvariant;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.loopInvariant == null ? 0 : this.loopInvariant.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LoopInvariantEntry)) {
            return false;
        }
        LoopInvariantEntry other = (LoopInvariantEntry)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.loopInvariant == null ? other.loopInvariant != null : !this.loopInvariant.equals(other.loopInvariant)) {
            return false;
        }
        return !(this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata));
    }

    @Override
    public String toString() {
        return "InvariantStoreEntry{ entry_type='" + this.getEntryType() + "', metadata='" + this.getMetadata() + "', location='" + this.getLocation() + "', loopInvariant='" + this.getLoopInvariant() + "'}";
    }
}

