/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.records.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public class TaskRecord {
    @JsonProperty(value="input_files")
    private final ImmutableList<String> inputFiles;
    @JsonProperty(value="input_file_hashes")
    private final ImmutableMap<String, String> inputFileHashes;
    @JsonProperty(value="specification")
    private final String specification;
    @JsonProperty(value="data_model")
    private final String dataModel;
    @JsonProperty(value="language")
    private final String language;

    public TaskRecord(@JsonProperty(value="input_files") List<String> pInputFiles, @JsonProperty(value="input_file_hashes") Map<String, String> pInputFileHashes, @JsonProperty(value="specification") String pSpecification, @JsonProperty(value="data_model") String pDataModel, @JsonProperty(value="language") String pLanguage) {
        this.inputFiles = ImmutableList.copyOf(pInputFiles);
        this.inputFileHashes = ImmutableMap.copyOf(pInputFileHashes);
        this.specification = pSpecification;
        this.dataModel = pDataModel;
        this.language = pLanguage;
    }

    public List<String> getInputFiles() {
        return this.inputFiles;
    }

    public Map<String, String> getInputFileHashes() {
        return this.inputFileHashes;
    }

    public String getSpecification() {
        return this.specification;
    }

    public String getDataModel() {
        return this.dataModel;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRecord)) {
            return false;
        }
        TaskRecord invariantStoreEntryTask = (TaskRecord)o;
        return Objects.equals(this.inputFiles, invariantStoreEntryTask.inputFiles) && Objects.equals(this.inputFileHashes, invariantStoreEntryTask.inputFileHashes) && Objects.equals(this.specification, invariantStoreEntryTask.specification) && Objects.equals(this.dataModel, invariantStoreEntryTask.dataModel) && Objects.equals(this.language, invariantStoreEntryTask.language);
    }

    public int hashCode() {
        return Objects.hash(this.inputFiles, this.inputFileHashes, this.specification, this.dataModel, this.language);
    }

    public String toString() {
        return "TaskRecord{ inputFiles='" + this.getInputFiles() + "', inputFileHashes='" + this.getInputFileHashes() + "', specification='" + this.getSpecification() + "', dataModel='" + this.getDataModel() + "', language='" + this.getLanguage() + "'}";
    }
}

