/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariantwitness.test;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.List;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.AbstractEntry;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.LoopInvariantCertificateEntry;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.model.LoopInvariantEntry;

public class InvariantWitnessTest {
    public static final String TEST_DIR_PATH = "test/witness/";

    @Test
    public void testParsingEntries() throws JsonParseException, JsonMappingException, IOException {
        File yamlWitness = Path.of(TEST_DIR_PATH, "loop_invariant_and_certificate.yml").toFile();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        CollectionType entryType = mapper.getTypeFactory().constructCollectionType(List.class, AbstractEntry.class);
        List entries = (List)mapper.readValue(yamlWitness, (JavaType)entryType);
        ArrayDeque loadedEntries = new ArrayDeque();
        loadedEntries.addAll(entries);
        for (AbstractEntry e : loadedEntries) {
            if (e instanceof LoopInvariantEntry) {
                LoopInvariantEntry invEntry = (LoopInvariantEntry)e;
                Truth.assertThat((String)invEntry.getLocation().getFileName()).isEqualTo((Object)"multivar_1-1.c");
                continue;
            }
            if (!(e instanceof LoopInvariantCertificateEntry)) continue;
            LoopInvariantCertificateEntry invCertEntry = (LoopInvariantCertificateEntry)e;
            Truth.assertThat((String)invCertEntry.getCertification().getString()).isEqualTo((Object)"confirmed");
        }
    }
}

