/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerStore;
import jhoafparser.parser.HOAFParser;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.storage.StoredAutomaton;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.BuechiConverterUtils;
import org.sosy_lab.cpachecker.util.ltl.LtlParseException;
import org.sosy_lab.cpachecker.util.ltl.LtlStringVisitor;
import org.sosy_lab.cpachecker.util.ltl.formulas.LabelledFormula;
import org.sosy_lab.cpachecker.util.ltl.formulas.Literal;

public class Ltl2BuechiConverter {
    private static final Converter EXECUTABLE = Converter.LTL3BA;
    private final LabelledFormula labelledFormula;
    private final ProcessExecutor<LtlParseException> executor;

    public static Automaton convertFormula(LabelledFormula pFormula, String pEntryFunction, Configuration pConfig, LogManager pLogger, MachineModel pMachineModel, Scope pScope, ShutdownNotifier pShutdownNotifier) throws InterruptedException, LtlParseException, IOException {
        Preconditions.checkNotNull((Object)pFormula);
        StoredAutomaton hoaAutomaton = new Ltl2BuechiConverter(pFormula, pLogger).createHoaAutomaton();
        return BuechiConverterUtils.convertFromHOAFormat(hoaAutomaton, pEntryFunction, pConfig, pLogger, pMachineModel, pScope, pShutdownNotifier);
    }

    public static String getNameOfExecutable() {
        return EXECUTABLE.getToolName();
    }

    private Ltl2BuechiConverter(LabelledFormula pFormula, LogManager pLogger) throws IOException, LtlParseException, InterruptedException {
        this.labelledFormula = pFormula;
        Path nativeLibraryPath = NativeLibraries.getNativeLibraryPath();
        String formula = LtlStringVisitor.toString(this.labelledFormula.getFormula(), this.labelledFormula.getAPs());
        ImmutableList commands = ImmutableList.builder().add((Object)EXECUTABLE.execTool()).addAll(EXECUTABLE.getArgs()).add((Object[])new String[]{"-f", formula}).build();
        this.executor = new ProcessExecutor(pLogger, LtlParseException.class, nativeLibraryPath.toFile(), (String[])commands.toArray((Object[])new String[0]));
        int exitvalue = this.executor.join();
        if (exitvalue != 0 || !this.executor.getErrorOutput().isEmpty()) {
            throw new LtlParseException(String.format("Tool '%s' exited with error code %d. Error log from the tool:%n%s", EXECUTABLE.getToolName(), exitvalue, this.executor.getErrorOutput().stream().collect(Collectors.joining("\n"))));
        }
    }

    private StoredAutomaton createHoaAutomaton() throws LtlParseException, IOException {
        StoredAutomaton storedAutomaton;
        List output = this.executor.getOutput();
        byte[] bytes = output.stream().collect(Collectors.joining("\n")).getBytes(IO.getNativeCharset());
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            HOAConsumerStore consumer = new HOAConsumerStore();
            HOAFParser.parseHOA((InputStream)is, (HOAConsumer)consumer);
            StoredAutomaton storedAutomaton2 = consumer.getStoredAutomaton();
            ArrayList<String> list = new ArrayList<String>(storedAutomaton2.getStoredHeader().getAPs().size());
            for (String s : storedAutomaton2.getStoredHeader().getAPs()) {
                int index = Integer.parseInt((String)Iterables.get((Iterable)Splitter.on((String)"val").split((CharSequence)s), (int)1));
                list.add(((Literal)this.labelledFormula.getAPs().get(index)).getAtom());
            }
            storedAutomaton2.getStoredHeader().setAPs(list);
            if (!storedAutomaton2.getStoredHeader().getAPs().stream().allMatch(x -> this.labelledFormula.getAPs().contains((Object)Literal.of(x, false)))) {
                throw new RuntimeException("Output from external tool contains atomic propositions (AP) which are not consistent with the APs from the provided LTL formula");
            }
            storedAutomaton = storedAutomaton2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException e) {
                throw new LtlParseException(String.format("An error occured while parsing the output from the external tool '%s'", EXECUTABLE.getToolName()), e);
            }
        }
        ((InputStream)is).close();
        return storedAutomaton;
    }

    private static class Converter {
        private static final Converter LTL3BA = new Converter("ltl3ba", "-H");
        private final String toolName;
        private final ImmutableList<String> commands;

        private Converter(String toolName, String ... commands) {
            this.toolName = toolName;
            this.commands = ImmutableList.copyOf((Object[])commands);
        }

        public String getToolName() {
            return this.toolName;
        }

        private String execTool() {
            return "./" + this.getToolName();
        }

        public ImmutableList<String> getArgs() {
            return this.commands;
        }
    }
}

