/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.ltl.LtlParseException;
import org.sosy_lab.cpachecker.util.ltl.LtlParser;
import org.sosy_lab.cpachecker.util.ltl.formulas.BooleanConstant;
import org.sosy_lab.cpachecker.util.ltl.formulas.Conjunction;
import org.sosy_lab.cpachecker.util.ltl.formulas.Disjunction;
import org.sosy_lab.cpachecker.util.ltl.formulas.Finally;
import org.sosy_lab.cpachecker.util.ltl.formulas.Globally;
import org.sosy_lab.cpachecker.util.ltl.formulas.Literal;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;
import org.sosy_lab.cpachecker.util.ltl.formulas.Next;
import org.sosy_lab.cpachecker.util.ltl.formulas.Release;
import org.sosy_lab.cpachecker.util.ltl.formulas.StrongRelease;
import org.sosy_lab.cpachecker.util.ltl.formulas.Until;
import org.sosy_lab.cpachecker.util.ltl.formulas.WeakUntil;

public class LtlFormulaParserTest {
    @Test
    public void test_parse_appliesRandomSyntaxCorrectly() throws LtlParseException {
        ImmutableList in = ImmutableList.of((Object)"!a", (Object)"G a", (Object)"F a & X b", (Object)"(a -> b) U c", (Object)"true U b", (Object)"a S b", (Object)"a R b", (Object)"!(a R b)", (Object)"a W b U c R a");
        ImmutableList out = ImmutableList.of((Object)new Literal("a", true), (Object)new Globally(new Literal("a")), (Object)new Conjunction(new Finally(new Literal("a")), new Next(new Literal("b"))), (Object)new Until(new Disjunction(new Literal("a", true), new Literal("b")), new Literal("c")), (Object)new Finally(new Literal("b")), (Object)new StrongRelease(new Literal("a"), new Literal("b")), (Object)new Release(new Literal("a"), new Literal("b")), (Object)new Until(new Literal("a", true), new Literal("b", true)), (Object)new WeakUntil(new Literal("a"), new Until(new Literal("b"), new Release(new Literal("c"), new Literal("a")))));
        for (int i = 0; i < in.size(); ++i) {
            Truth.assertWithMessage((String)((String)in.get(i))).that(out.get(i)).isEqualTo((Object)LtlParser.parseProperty((String)in.get(i)).getFormula());
        }
    }

    @Test
    public void test_parse_APs_appliesTrivialIdentities() throws LtlParseException {
        ImmutableList in = ImmutableList.of((Object)"!false", (Object)"!true", (Object)"!!true", (Object)"true -> a", (Object)"false -> a", (Object)"a -> true", (Object)"a -> false", (Object)"a -> a");
        ImmutableList out = ImmutableList.of((Object)BooleanConstant.TRUE, (Object)BooleanConstant.FALSE, (Object)BooleanConstant.TRUE, (Object)new Literal("a"), (Object)BooleanConstant.TRUE, (Object)BooleanConstant.TRUE, (Object)new Literal("a", true), (Object)BooleanConstant.TRUE);
        for (int i = 0; i < in.size(); ++i) {
            Truth.assertWithMessage((String)((String)in.get(i))).that(out.get(i)).isEqualTo((Object)LtlParser.parseProperty((String)in.get(i)).getFormula());
        }
    }

    @Test
    public void test_parse_APs_appliesCommutativeIdentities() throws LtlParseException {
        ImmutableList in = ImmutableList.of((Object)"false && a", (Object)"true && a", (Object)"a && false", (Object)"a && true", (Object)"a && a", (Object)"false || a", (Object)"true || a", (Object)"a || false", (Object)"a || true", (Object)"a || a", (Object)"false XOR a", (Object)"true XOR a", (Object[])new String[]{"a XOR false", "a XOR true", "a XOR a", "false <-> a", "true <-> a", "a <-> false", "a <-> true", "a <-> a"});
        ImmutableList out = ImmutableList.of((Object)BooleanConstant.FALSE, (Object)new Literal("a"), (Object)BooleanConstant.FALSE, (Object)new Literal("a"), (Object)new Literal("a"), (Object)new Literal("a"), (Object)BooleanConstant.TRUE, (Object)new Literal("a"), (Object)BooleanConstant.TRUE, (Object)new Literal("a"), (Object)new Literal("a"), (Object)new Literal("a", true), (Object[])new LtlFormula[]{new Literal("a"), new Literal("a", true), BooleanConstant.FALSE, new Literal("a", true), new Literal("a"), new Literal("a", true), new Literal("a"), BooleanConstant.TRUE});
        for (int i = 0; i < in.size(); ++i) {
            Truth.assertWithMessage((String)((String)in.get(i))).that(out.get(i)).isEqualTo((Object)LtlParser.parseProperty((String)in.get(i)).getFormula());
        }
    }

    @Test
    public void test_parse_temporalOperators_appliesTrivialIdentities() throws LtlParseException {
        ImmutableList in = ImmutableList.of((Object)"X false", (Object)"X true", (Object)"F false", (Object)"F true", (Object)"F F a", (Object)"G false", (Object)"G true", (Object)"G G a", (Object)"a U true", (Object)"false U a", (Object)"a U false", (Object)"a U a", (Object[])new String[]{"a W true", "false W a", "true W a", "a W a", "a S false", "false S a", "true S a", "a S a", "a R true", "a R false", "true R a", "a R a"});
        ImmutableList out = ImmutableList.of((Object)BooleanConstant.FALSE, (Object)BooleanConstant.TRUE, (Object)BooleanConstant.FALSE, (Object)BooleanConstant.TRUE, (Object)new Finally(new Literal("a")), (Object)BooleanConstant.FALSE, (Object)BooleanConstant.TRUE, (Object)new Globally(new Literal("a")), (Object)BooleanConstant.TRUE, (Object)new Literal("a"), (Object)BooleanConstant.FALSE, (Object)new Literal("a"), (Object[])new LtlFormula[]{BooleanConstant.TRUE, new Literal("a"), BooleanConstant.TRUE, new Literal("a"), BooleanConstant.FALSE, BooleanConstant.FALSE, new Literal("a"), new Literal("a"), BooleanConstant.TRUE, BooleanConstant.FALSE, new Literal("a"), new Literal("a")});
        for (int i = 0; i < in.size(); ++i) {
            Truth.assertWithMessage((String)((String)in.get(i))).that(out.get(i)).isEqualTo((Object)LtlParser.parseProperty((String)in.get(i)).getFormula());
        }
    }
}

