/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.sosy_lab.cpachecker.util.ltl.formulas.BooleanConstant;
import org.sosy_lab.cpachecker.util.ltl.formulas.Conjunction;
import org.sosy_lab.cpachecker.util.ltl.formulas.Disjunction;
import org.sosy_lab.cpachecker.util.ltl.formulas.Finally;
import org.sosy_lab.cpachecker.util.ltl.formulas.Globally;
import org.sosy_lab.cpachecker.util.ltl.formulas.Literal;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;
import org.sosy_lab.cpachecker.util.ltl.formulas.Next;
import org.sosy_lab.cpachecker.util.ltl.formulas.Release;
import org.sosy_lab.cpachecker.util.ltl.formulas.StrongRelease;
import org.sosy_lab.cpachecker.util.ltl.formulas.Until;
import org.sosy_lab.cpachecker.util.ltl.formulas.WeakUntil;
import org.sosy_lab.cpachecker.util.ltl.generated.LtlGrammarParser;
import org.sosy_lab.cpachecker.util.ltl.generated.LtlGrammarParserBaseVisitor;

public class LtlFormulaTreeVisitor
extends LtlGrammarParserBaseVisitor<LtlFormula> {
    private final List<Literal> apList = new ArrayList<Literal>();

    public List<Literal> getAPs() {
        return ImmutableList.copyOf(this.apList);
    }

    @Override
    public LtlFormula visitProperty(LtlGrammarParser.PropertyContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 7);
        return (LtlFormula)this.visit(ctx.getChild(4));
    }

    @Override
    public LtlFormula visitLtlProperty(LtlGrammarParser.LtlPropertyContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 4);
        return (LtlFormula)this.visit(ctx.getChild(2));
    }

    @Override
    public LtlFormula visitFormula(LtlGrammarParser.FormulaContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 2);
        return (LtlFormula)this.visit(ctx.getChild(0));
    }

    @Override
    public LtlFormula visitExpression(LtlGrammarParser.ExpressionContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 1);
        return (LtlFormula)this.visit(ctx.getChild(0));
    }

    @Override
    public LtlFormula visitOrExpression(LtlGrammarParser.OrExpressionContext ctx) {
        if (ctx.getChildCount() == 0) {
            throw new RuntimeException("Invalid input provided. Expected at least 1 child-node in param 'ctx', however, nothing could be found");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (i % 2 == 0) {
                builder.add((Object)((LtlFormula)this.visit(ctx.getChild(i))));
                continue;
            }
            if (ctx.getChild(i) instanceof TerminalNode) continue;
            throw new RuntimeException(String.format("Invalid input provided. Expected child at pos %d to be an instance of TerminalNode", i));
        }
        return Disjunction.of((Iterable<? extends LtlFormula>)builder.build());
    }

    @Override
    public LtlFormula visitAndExpression(LtlGrammarParser.AndExpressionContext ctx) {
        if (ctx.getChildCount() == 0) {
            throw new RuntimeException("Invalid input provided. Expected at least 1 child-node in param 'ctx', however, nothing could be found");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (i % 2 == 0) {
                builder.add((Object)((LtlFormula)this.visit(ctx.getChild(i))));
                continue;
            }
            if (ctx.getChild(i) instanceof TerminalNode) continue;
            throw new RuntimeException(String.format("Invalid input provided. Expected child at pos %d to be an instance of TerminalNode", i));
        }
        return Conjunction.of((Iterable<? extends LtlFormula>)builder.build());
    }

    @Override
    public LtlFormula visitBinaryOperation(LtlGrammarParser.BinaryOperationContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 3);
        Objects.requireNonNull(ctx.left);
        Objects.requireNonNull(ctx.right);
        LtlGrammarParser.BinaryOpContext binaryOp = ctx.binaryOp();
        LtlFormula left = (LtlFormula)this.visit((ParseTree)ctx.left);
        LtlFormula right = (LtlFormula)this.visit((ParseTree)ctx.right);
        if (binaryOp.EQUIV() != null) {
            return Disjunction.of(Conjunction.of(left, right), Conjunction.of(left.not(), right.not()));
        }
        if (binaryOp.IMP() != null) {
            return Disjunction.of(left.not(), right);
        }
        if (binaryOp.XOR() != null) {
            return Disjunction.of(Conjunction.of(left, right.not()), Conjunction.of(left.not(), right));
        }
        if (binaryOp.UNTIL() != null) {
            return Until.of(left, right);
        }
        if (binaryOp.WUNTIL() != null) {
            return WeakUntil.of(left, right);
        }
        if (binaryOp.RELEASE() != null) {
            return Release.of(left, right);
        }
        if (binaryOp.SRELEASE() != null) {
            return StrongRelease.of(left, right);
        }
        throw new ParseCancellationException("Unknown binary operator");
    }

    @Override
    public LtlFormula visitUnaryOperation(LtlGrammarParser.UnaryOperationContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 2);
        LtlGrammarParser.UnaryOpContext unaryOp = ctx.unaryOp();
        LtlFormula operand = (LtlFormula)this.visit((ParseTree)ctx.inner);
        if (unaryOp.NOT() != null) {
            return operand.not();
        }
        if (unaryOp.FINALLY() != null) {
            return Finally.of(operand);
        }
        if (unaryOp.GLOBALLY() != null) {
            return Globally.of(operand);
        }
        if (unaryOp.NEXT() != null) {
            return Next.of(operand);
        }
        throw new ParseCancellationException("Unknown unary operator");
    }

    @Override
    public LtlFormula visitBoolean(LtlGrammarParser.BooleanContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 1);
        LtlGrammarParser.BoolContext constant = ctx.bool();
        if (constant.FALSE() != null) {
            return BooleanConstant.FALSE;
        }
        if (constant.TRUE() != null) {
            return BooleanConstant.TRUE;
        }
        throw new ParseCancellationException("Unknown boolean constant");
    }

    @Override
    public LtlFormula visitQuotedVariable(LtlGrammarParser.QuotedVariableContext ctx) {
        if (ctx.getChildCount() < 5) {
            throw new RuntimeException(String.format("Invalid input provided. Expected %d child-nodes in param 'ctx', however, %d were found", 5, ctx.getChildCount()));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < ctx.getChildCount() - 1; ++i) {
            sb.append(ctx.getChild(i).getText());
        }
        Literal ap = Literal.of(sb.toString(), false);
        this.apList.add(ap);
        return ap;
    }

    @Override
    public LtlFormula visitVariable(LtlGrammarParser.VariableContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 1);
        Literal ap = Literal.of(ctx.getText(), false);
        this.apList.add(ap);
        return ap;
    }

    @Override
    public LtlFormula visitNested(LtlGrammarParser.NestedContext ctx) {
        this.throwException_When_InvalidChildCount(ctx.getChildCount(), 3);
        return (LtlFormula)this.visit((ParseTree)ctx.nested);
    }

    private void throwException_When_InvalidChildCount(int pActual, int pExpected) {
        if (pActual == pExpected) {
            return;
        }
        throw new RuntimeException(String.format("Invalid input provided. Expected %d child-nodes in param 'ctx', however, %d were found", pExpected, pActual));
    }
}

