/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.sosy_lab.cpachecker.util.ltl.LtlFormulaTreeVisitor;
import org.sosy_lab.cpachecker.util.ltl.LtlParseException;
import org.sosy_lab.cpachecker.util.ltl.LtlParserErrorListener;
import org.sosy_lab.cpachecker.util.ltl.formulas.LabelledFormula;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;
import org.sosy_lab.cpachecker.util.ltl.generated.LtlGrammarParser;
import org.sosy_lab.cpachecker.util.ltl.generated.LtlGrammarParserBaseVisitor;
import org.sosy_lab.cpachecker.util.ltl.generated.LtlLexer;

public abstract class LtlParser
extends LtlGrammarParserBaseVisitor<LtlFormula> {
    private final CharStream input;

    private LtlParser(CharStream pInput) {
        this.input = (CharStream)Preconditions.checkNotNull((Object)pInput);
    }

    public static LabelledFormula parseProperty(String pRaw) throws LtlParseException {
        Preconditions.checkNotNull((Object)pRaw);
        return new LtlFormulaParser((CharStream)CharStreams.fromString((String)pRaw)).doParse();
    }

    public static LabelledFormula parseSpecificationFromFile(Path pPath) throws LtlParseException {
        Preconditions.checkNotNull((Object)pPath);
        try {
            return new LtlPropertyFileParser(CharStreams.fromStream((InputStream)Files.newInputStream(pPath, new OpenOption[0]))).doParse();
        }
        catch (IOException e) {
            throw new LtlParseException(e.getMessage(), e);
        }
    }

    @VisibleForTesting
    static LabelledFormula parseSpecification(String pRaw) throws LtlParseException {
        Preconditions.checkNotNull((Object)pRaw);
        return new LtlPropertyFileParser((CharStream)CharStreams.fromString((String)pRaw)).doParse();
    }

    abstract ParseTree getParseTree(LtlGrammarParser var1);

    LabelledFormula doParse() throws LtlParseException {
        try {
            LtlLexer lexer = new LtlLexer(this.input);
            lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
            lexer.addErrorListener((ANTLRErrorListener)LtlParserErrorListener.INSTANCE);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            LtlGrammarParser parser = new LtlGrammarParser((TokenStream)tokens);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)LtlParserErrorListener.INSTANCE);
            LtlFormulaTreeVisitor visitor = new LtlFormulaTreeVisitor();
            ParseTree tree = this.getParseTree(parser);
            return LabelledFormula.of((LtlFormula)visitor.visit(tree), visitor.getAPs());
        }
        catch (ParseCancellationException e) {
            throw new LtlParseException(e.getMessage(), e);
        }
    }

    private static class LtlPropertyFileParser
    extends LtlParser {
        LtlPropertyFileParser(CharStream input) {
            super(input);
        }

        @Override
        ParseTree getParseTree(LtlGrammarParser parser) {
            return parser.property();
        }
    }

    private static class LtlFormulaParser
    extends LtlParser {
        LtlFormulaParser(CharStream input) {
            super(input);
        }

        @Override
        ParseTree getParseTree(LtlGrammarParser parser) {
            return parser.formula();
        }
    }
}

