/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl.formulas;

import java.util.Objects;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;

public abstract class BinaryFormula
implements LtlFormula {
    private final LtlFormula left;
    private final LtlFormula right;

    BinaryFormula(LtlFormula pLeft, LtlFormula pRight) {
        this.left = Objects.requireNonNull(pLeft);
        this.right = Objects.requireNonNull(pRight);
    }

    public LtlFormula getLeft() {
        return this.left;
    }

    public LtlFormula getRight() {
        return this.right;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.left, this.right, this.getSymbol());
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BinaryFormula)) {
            return false;
        }
        BinaryFormula other = (BinaryFormula)obj;
        return this.getSymbol().equals(other.getSymbol()) && this.left.equals(other.left) && this.right.equals(other.right);
    }

    public abstract String getSymbol();

    @Override
    public String toString() {
        return String.format("(%s %s %s)", this.left, this.getSymbol(), this.right);
    }
}

