/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl.formulas;

import org.sosy_lab.cpachecker.util.ltl.LtlFormulaVisitor;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;

public final class BooleanConstant
implements LtlFormula {
    public static final BooleanConstant FALSE = new BooleanConstant(false);
    public static final BooleanConstant TRUE = new BooleanConstant(true);
    private final boolean value;

    public static BooleanConstant of(boolean pValue) {
        return pValue ? TRUE : FALSE;
    }

    private BooleanConstant(boolean pValue) {
        this.value = pValue;
    }

    @Override
    public BooleanConstant not() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public String accept(LtlFormulaVisitor v) {
        return v.visit(this);
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanConstant other = (BooleanConstant)obj;
        return this.value == other.value;
    }

    @Override
    public String toString() {
        return this.value ? "true" : "false";
    }
}

