/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl.formulas;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.util.ltl.LtlFormulaVisitor;
import org.sosy_lab.cpachecker.util.ltl.formulas.BooleanConstant;
import org.sosy_lab.cpachecker.util.ltl.formulas.Disjunction;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;
import org.sosy_lab.cpachecker.util.ltl.formulas.PropositionalFormula;

public final class Conjunction
extends PropositionalFormula {
    public Conjunction(Iterable<? extends LtlFormula> pConjuncts) {
        super(pConjuncts);
    }

    public Conjunction(LtlFormula ... pConjuncts) {
        super(pConjuncts);
    }

    public static LtlFormula of(LtlFormula pLeft, LtlFormula pRight) {
        return Conjunction.of(Arrays.asList(pLeft, pRight));
    }

    public static LtlFormula of(LtlFormula ... pFormulas) {
        return Conjunction.of(Arrays.asList(pFormulas));
    }

    public static LtlFormula of(Iterable<? extends LtlFormula> pIterable) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (LtlFormula ltlFormula : pIterable) {
            if (ltlFormula == BooleanConstant.FALSE) {
                return BooleanConstant.FALSE;
            }
            if (ltlFormula == BooleanConstant.TRUE) continue;
            if (ltlFormula instanceof Conjunction) {
                builder.addAll(((Conjunction)ltlFormula).getChildren());
                continue;
            }
            builder.add((Object)ltlFormula);
        }
        ImmutableSet set = builder.build();
        if (set.isEmpty()) {
            return BooleanConstant.TRUE;
        }
        if (set.size() == 1) {
            return (LtlFormula)set.iterator().next();
        }
        if (set.stream().anyMatch(x -> set.contains((Object)x.not()))) {
            return BooleanConstant.FALSE;
        }
        return new Conjunction((Iterable<? extends LtlFormula>)set);
    }

    @Override
    public LtlFormula not() {
        return new Disjunction((Iterable<? extends LtlFormula>)Collections3.transformedImmutableSetCopy(this.getChildren(), LtlFormula::not));
    }

    @Override
    public String accept(LtlFormulaVisitor v) {
        return v.visit(this);
    }

    @Override
    public String getSymbol() {
        return "&&";
    }
}

