/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl.formulas;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.util.ltl.LtlFormulaVisitor;
import org.sosy_lab.cpachecker.util.ltl.formulas.BooleanConstant;
import org.sosy_lab.cpachecker.util.ltl.formulas.Conjunction;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;
import org.sosy_lab.cpachecker.util.ltl.formulas.PropositionalFormula;

public final class Disjunction
extends PropositionalFormula {
    public Disjunction(Iterable<? extends LtlFormula> pDisjuncts) {
        super(pDisjuncts);
    }

    public Disjunction(LtlFormula ... pDisjuncts) {
        super(pDisjuncts);
    }

    public static LtlFormula of(LtlFormula pLeft, LtlFormula pRight) {
        return Disjunction.of(Arrays.asList(pLeft, pRight));
    }

    public static LtlFormula of(LtlFormula ... pFormulas) {
        return Disjunction.of(Arrays.asList(pFormulas));
    }

    public static LtlFormula of(Iterable<? extends LtlFormula> pIterable) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (LtlFormula ltlFormula : pIterable) {
            if (ltlFormula == BooleanConstant.TRUE) {
                return BooleanConstant.TRUE;
            }
            if (ltlFormula == BooleanConstant.FALSE) continue;
            if (ltlFormula instanceof Disjunction) {
                builder.addAll(((Disjunction)ltlFormula).getChildren());
                continue;
            }
            builder.add((Object)ltlFormula);
        }
        ImmutableSet set = builder.build();
        if (set.isEmpty()) {
            return BooleanConstant.FALSE;
        }
        if (set.size() == 1) {
            return (LtlFormula)set.iterator().next();
        }
        if (set.stream().anyMatch(x -> set.contains((Object)x.not()))) {
            return BooleanConstant.TRUE;
        }
        return new Disjunction((Iterable<? extends LtlFormula>)set);
    }

    @Override
    public LtlFormula not() {
        return new Conjunction((Iterable<? extends LtlFormula>)Collections3.transformedImmutableSetCopy(this.getChildren(), LtlFormula::not));
    }

    @Override
    public String accept(LtlFormulaVisitor v) {
        return v.visit(this);
    }

    @Override
    public String getSymbol() {
        return "||";
    }
}

