/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl.formulas;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.util.ltl.formulas.Literal;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;

public final class LabelledFormula {
    private final LtlFormula formula;
    private final ImmutableList<Literal> atomicPropositions;

    public static LabelledFormula of(LtlFormula pFormula, List<Literal> pList) {
        return new LabelledFormula(pFormula, pList);
    }

    private LabelledFormula(LtlFormula pFormula, List<Literal> pList) {
        this.formula = (LtlFormula)Preconditions.checkNotNull((Object)pFormula);
        this.atomicPropositions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(pList)));
    }

    public LabelledFormula not() {
        return LabelledFormula.of(this.formula.not(), this.atomicPropositions);
    }

    public LtlFormula getFormula() {
        return this.formula;
    }

    public ImmutableList<Literal> getAPs() {
        return this.atomicPropositions;
    }

    public int hashCode() {
        return Objects.hash(this.atomicPropositions, this.formula);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelledFormula)) {
            return false;
        }
        LabelledFormula other = (LabelledFormula)obj;
        return this.formula.equals(other.formula) && this.atomicPropositions.equals(other.atomicPropositions);
    }

    public String toString() {
        return this.getFormula().toString();
    }
}

