/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl.formulas;

import java.util.Objects;
import org.sosy_lab.cpachecker.util.ltl.LtlFormulaVisitor;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;

public final class Literal
implements LtlFormula {
    private final String atom;
    private final boolean negated;
    private final Literal negation;

    public static Literal of(String pName, boolean pNegated) {
        return new Literal(pName, pNegated);
    }

    private Literal(Literal pOther) {
        Objects.requireNonNull(pOther);
        this.atom = pOther.atom;
        this.negated = !pOther.negated;
        this.negation = pOther;
    }

    public Literal(String pName) {
        this(pName, false);
    }

    public Literal(String pName, boolean pNegated) {
        Objects.requireNonNull(pName);
        this.atom = pName;
        this.negated = pNegated;
        this.negation = new Literal(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.atom, this.negated);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)obj;
        return this.atom.equals(other.atom) && this.negated == other.negated;
    }

    public String getAtom() {
        return this.atom;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public Literal not() {
        return this.negation;
    }

    @Override
    public String accept(LtlFormulaVisitor v) {
        return v.visit(this);
    }

    @Override
    public String toString() {
        return this.isNegated() ? "! " + this.atom : this.atom;
    }
}

