/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl.formulas;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;

public abstract class PropositionalFormula
implements LtlFormula {
    private final ImmutableList<? extends LtlFormula> children;

    PropositionalFormula(Iterable<? extends LtlFormula> pChildren) {
        this.children = ImmutableList.copyOf(pChildren);
    }

    PropositionalFormula(LtlFormula ... pChildren) {
        this.children = ImmutableList.copyOf((Object[])pChildren);
    }

    public ImmutableList<? extends LtlFormula> getChildren() {
        return this.children;
    }

    @Override
    public final int hashCode() {
        int prime = 31;
        return 31 + this.children.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropositionalFormula)) {
            return false;
        }
        PropositionalFormula other = (PropositionalFormula)obj;
        return this.getSymbol().equals(other.getSymbol()) && this.children.equals(other.children);
    }

    public abstract String getSymbol();

    @Override
    public String toString() {
        return "(" + String.join((CharSequence)(" " + this.getSymbol() + " "), Iterables.transform(this.children, Object::toString)) + ")";
    }
}

