/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ltl.formulas;

import org.sosy_lab.cpachecker.util.ltl.LtlFormulaVisitor;
import org.sosy_lab.cpachecker.util.ltl.formulas.BinaryFormula;
import org.sosy_lab.cpachecker.util.ltl.formulas.BooleanConstant;
import org.sosy_lab.cpachecker.util.ltl.formulas.Disjunction;
import org.sosy_lab.cpachecker.util.ltl.formulas.Globally;
import org.sosy_lab.cpachecker.util.ltl.formulas.LtlFormula;
import org.sosy_lab.cpachecker.util.ltl.formulas.StrongRelease;

public final class WeakUntil
extends BinaryFormula {
    public WeakUntil(LtlFormula pLeft, LtlFormula pRight) {
        super(pLeft, pRight);
    }

    public static LtlFormula of(LtlFormula pLeft, LtlFormula pRight) {
        if (pLeft == BooleanConstant.TRUE || pRight == BooleanConstant.TRUE) {
            return BooleanConstant.TRUE;
        }
        if (pLeft == BooleanConstant.FALSE) {
            return pRight;
        }
        if (pLeft.equals(pRight)) {
            return pLeft;
        }
        if (pRight == BooleanConstant.FALSE) {
            return Globally.of(pLeft);
        }
        if (pLeft instanceof Globally) {
            return Disjunction.of(pLeft, pRight);
        }
        return new WeakUntil(pLeft, pRight);
    }

    @Override
    public String getSymbol() {
        return "W";
    }

    @Override
    public StrongRelease not() {
        return new StrongRelease(this.getLeft().not(), this.getRight().not());
    }

    @Override
    public String accept(LtlFormulaVisitor v) {
        return v.visit(this);
    }
}

