/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.octagon;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;
import org.sosy_lab.cpachecker.util.octagon.OctagonPhantomReference;

public class Octagon {
    private final long octId;
    private final OctagonManager manager;
    private static List<OctagonPhantomReference> phantomReferences = new ArrayList<OctagonPhantomReference>();
    private static ReferenceQueue<Octagon> referenceQueue = new ReferenceQueue();

    Octagon(long l, OctagonManager manager) {
        this.octId = l;
        this.manager = manager;
        Octagon.registerPhantomReference(this);
    }

    private static void registerPhantomReference(Octagon oct) {
        phantomReferences.add(new OctagonPhantomReference(oct, referenceQueue));
    }

    public static void removePhantomReferences() {
        Reference<Octagon> reference;
        while ((reference = referenceQueue.poll()) != null) {
            ((OctagonPhantomReference)reference).cleanup();
        }
    }

    long getOctId() {
        return this.octId;
    }

    public OctagonManager getManager() {
        return this.manager;
    }

    public int hashCode() {
        return (int)this.octId;
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof Octagon)) {
            return false;
        }
        Octagon otherOct = (Octagon)pObj;
        return this.manager.dimension(this) == otherOct.manager.dimension(otherOct) && this.manager.isEqual(this, otherOct);
    }

    public String toString() {
        return "octagon with id: " + this.octId;
    }
}

