/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.octagon;

import com.google.common.collect.BiMap;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonDoubleValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonIntValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonInterval;
import org.sosy_lab.cpachecker.util.octagon.NumArray;
import org.sosy_lab.cpachecker.util.octagon.OctWrapper;
import org.sosy_lab.cpachecker.util.octagon.Octagon;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class OctagonIntManager
extends OctagonManager {
    public OctagonIntManager() {
        super("JOct_int");
    }

    @Override
    public String print(Octagon oct, BiMap<Integer, MemoryLocation> map) {
        StringBuilder str = new StringBuilder();
        int dimension = this.dimension(oct);
        long pointer = oct.getOctId();
        str.append("Octagon (id: " + pointer + ") (dimension: " + dimension + ")\n");
        if (this.isEmpty(oct)) {
            str.append("[Empty]\n");
            return str.toString();
        }
        NumArray lower = this.init_num_t(1);
        NumArray upper = this.init_num_t(1);
        for (int i = 0; i < map.size(); ++i) {
            str.append(" ").append(map.get((Object)i)).append(" -> [");
            OctWrapper.J_get_bounds(oct.getOctId(), i, upper.getArray(), lower.getArray());
            if (OctWrapper.J_num_infty(lower.getArray(), 0)) {
                str.append("-INFINITY, ");
            } else {
                str.append(OctWrapper.J_num_get_int(lower.getArray(), 0) * -1L).append(", ");
            }
            if (OctWrapper.J_num_infty(upper.getArray(), 0)) {
                str.append("INFINITY]\n");
                continue;
            }
            str.append(OctWrapper.J_num_get_int(upper.getArray(), 0)).append("]\n");
        }
        OctWrapper.J_num_clear_n(lower.getArray(), 1);
        OctWrapper.J_num_clear_n(upper.getArray(), 1);
        return str.toString();
    }

    @Override
    public OctagonInterval getVariableBounds(Octagon oct, int id) {
        NumArray lower = this.init_num_t(1);
        NumArray upper = this.init_num_t(1);
        assert (id < this.dimension(oct));
        OctWrapper.J_get_bounds(oct.getOctId(), id, upper.getArray(), lower.getArray());
        boolean lowerInfinite = OctWrapper.J_num_infty(lower.getArray(), 0);
        boolean upperInfinite = OctWrapper.J_num_infty(upper.getArray(), 0);
        OctagonInterval retVal = lowerInfinite && upperInfinite ? new OctagonInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) : (lowerInfinite ? new OctagonInterval(new OctagonDoubleValue(Double.NEGATIVE_INFINITY), OctagonIntValue.of(OctWrapper.J_num_get_int(upper.getArray(), 0))) : (upperInfinite ? new OctagonInterval(OctagonIntValue.of(OctWrapper.J_num_get_int(lower.getArray(), 0) * -1L), new OctagonDoubleValue(Double.POSITIVE_INFINITY)) : new OctagonInterval((double)(OctWrapper.J_num_get_int(lower.getArray(), 0) * -1L), (double)OctWrapper.J_num_get_int(upper.getArray(), 0))));
        OctWrapper.J_num_clear_n(lower.getArray(), 1);
        OctWrapper.J_num_clear_n(upper.getArray(), 1);
        return retVal;
    }
}

