/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.octagon;

import com.google.common.collect.BiMap;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonInterval;
import org.sosy_lab.cpachecker.util.octagon.NumArray;
import org.sosy_lab.cpachecker.util.octagon.OctWrapper;
import org.sosy_lab.cpachecker.util.octagon.Octagon;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public abstract class OctagonManager {
    private static boolean libraryLoaded = false;

    protected OctagonManager(String libraryName) {
        if (!libraryLoaded) {
            libraryLoaded = true;
            NativeLibraries.loadLibrary((String)libraryName);
            OctWrapper.J_init();
        }
    }

    public final NumArray init_num_t(int n) {
        return new NumArray(OctWrapper.J_init_n(n));
    }

    public final void num_set(NumArray n1, NumArray n2) {
        OctWrapper.J_num_set(n1.getArray(), n2.getArray());
    }

    public final Octagon set_bounds(Octagon oct, int pos, NumArray lower, NumArray upper) {
        return new Octagon(OctWrapper.J_set_bounds(oct.getOctId(), pos, lower.getArray(), upper.getArray(), false), this);
    }

    public final void num_set_int(NumArray n, int pos, long i) {
        OctWrapper.J_num_set_int(n.getArray(), pos, (int)i);
    }

    public final void num_set_float(NumArray n, int pos, double d) {
        OctWrapper.J_num_set_float(n.getArray(), pos, d);
    }

    public final void num_set_inf(NumArray n, int pos) {
        OctWrapper.J_num_set_inf(n.getArray(), pos);
    }

    public final long num_get_int(NumArray n, int pos) {
        return OctWrapper.J_num_get_int(n.getArray(), pos);
    }

    public final double num_get_float(NumArray n, int pos) {
        return OctWrapper.J_num_get_float(n.getArray(), pos);
    }

    public final boolean num_infty(NumArray n, int pos) {
        return OctWrapper.J_num_infty(n.getArray(), pos);
    }

    public final void num_clear_n(NumArray n, int size) {
        OctWrapper.J_num_clear_n(n.getArray(), size);
    }

    public final Octagon empty(int n) {
        return new Octagon(OctWrapper.J_empty(n), this);
    }

    public final Octagon universe(int n) {
        return new Octagon(OctWrapper.J_universe(n), this);
    }

    final void free(Long oct) {
        OctWrapper.J_free(oct);
    }

    public final Octagon copy(Octagon oct) {
        return new Octagon(OctWrapper.J_copy(oct.getOctId()), this);
    }

    public final Octagon full_copy(Octagon oct) {
        return new Octagon(OctWrapper.J_full_copy(oct.getOctId()), this);
    }

    public final int dimension(Octagon oct) {
        return OctWrapper.J_dimension(oct.getOctId());
    }

    public final int nbconstraints(Octagon oct) {
        return OctWrapper.J_nbconstraints(oct.getOctId());
    }

    public final boolean isEmpty(Octagon oct) {
        return OctWrapper.J_isEmpty(oct.getOctId());
    }

    public final int isEmptyLazy(Octagon oct) {
        return OctWrapper.J_isEmptyLazy(oct.getOctId());
    }

    public final boolean isUniverse(Octagon oct) {
        return OctWrapper.J_isUniverse(oct.getOctId());
    }

    public final boolean isIncludedIn(Octagon oct1, Octagon oct2) {
        return OctWrapper.J_isIncludedIn(oct1.getOctId(), oct2.getOctId());
    }

    public final int isIncludedInLazy(Octagon oct1, Octagon oct2) {
        return OctWrapper.J_isIncludedInLazy(oct1.getOctId(), oct2.getOctId());
    }

    public final boolean isEqual(Octagon oct1, Octagon oct2) {
        return OctWrapper.J_isEqual(oct1.getOctId(), oct2.getOctId());
    }

    public final int isEqualLazy(Octagon oct1, Octagon oct2) {
        return OctWrapper.J_isEqualLazy(oct1.getOctId(), oct2.getOctId());
    }

    public final boolean isIn(Octagon oct1, NumArray array) {
        return OctWrapper.J_isIn(oct1.getOctId(), array.getArray());
    }

    public final Octagon intersection(Octagon oct1, Octagon oct2) {
        return new Octagon(OctWrapper.J_intersection(oct1.getOctId(), oct2.getOctId(), false), this);
    }

    public final Octagon union(Octagon oct1, Octagon oct2) {
        return new Octagon(OctWrapper.J_union(oct1.getOctId(), oct2.getOctId(), false), this);
    }

    public final Octagon widening(Octagon oct1, Octagon oct2) {
        return new Octagon(OctWrapper.J_widening(oct1.getOctId(), oct2.getOctId(), false, 1), this);
    }

    public final Octagon narrowing(Octagon oct1, Octagon oct2) {
        return new Octagon(OctWrapper.J_narrowing(oct1.getOctId(), oct2.getOctId(), false), this);
    }

    public final Octagon forget(Octagon oct, int k) {
        return new Octagon(OctWrapper.J_forget(oct.getOctId(), k, false), this);
    }

    public final Octagon assingVar(Octagon oct, int k, NumArray array) {
        return new Octagon(OctWrapper.J_assingVar(oct.getOctId(), k, array.getArray(), false), this);
    }

    public final Octagon addBinConstraint(Octagon oct, int noOfConstraints, NumArray array) {
        return new Octagon(OctWrapper.J_addBinConstraints(oct.getOctId(), noOfConstraints, array.getArray(), false), this);
    }

    public final Octagon substituteVar(Octagon oct, int x, NumArray array) {
        return new Octagon(OctWrapper.J_substituteVar(oct.getOctId(), x, array.getArray(), false), this);
    }

    public final Octagon addConstraint(Octagon oct, NumArray array) {
        return new Octagon(OctWrapper.J_addConstraint(oct.getOctId(), array.getArray(), false), this);
    }

    public final Octagon intervAssingVar(Octagon oct, int k, NumArray array) {
        return new Octagon(OctWrapper.J_intervAssingVar(oct.getOctId(), k, array.getArray(), false), this);
    }

    public final Octagon intervSubstituteVar(Octagon oct, int x, NumArray array) {
        return new Octagon(OctWrapper.J_intervSubstituteVar(oct.getOctId(), x, array.getArray(), false), this);
    }

    public final Octagon intervAddConstraint(Octagon oct, NumArray array) {
        return new Octagon(OctWrapper.J_intervAddConstraint(oct.getOctId(), array.getArray(), false), this);
    }

    public final Octagon addDimensionAndEmbed(Octagon oct, int k) {
        return new Octagon(OctWrapper.J_addDimenensionAndEmbed(oct.getOctId(), k, false), this);
    }

    public final Octagon addDimensionAndProject(Octagon oct, int k) {
        return new Octagon(OctWrapper.J_addDimenensionAndProject(oct.getOctId(), k, false), this);
    }

    public final Octagon removeDimension(Octagon oct, int k) {
        return new Octagon(OctWrapper.J_removeDimension(oct.getOctId(), k, false), this);
    }

    public final void printNum(NumArray arr, int size) {
        OctWrapper.J_printNum(arr.getArray(), size);
    }

    public final void printOct(Octagon oct) {
        OctWrapper.J_print(oct.getOctId());
    }

    public abstract String print(Octagon var1, BiMap<Integer, MemoryLocation> var2);

    public abstract OctagonInterval getVariableBounds(Octagon var1, int var2);
}

