/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.octagon;

import com.google.common.truth.Truth;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.octagon.NumArray;
import org.sosy_lab.cpachecker.util.octagon.OctagonFloatManager;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;

public class OctagonManagerTest {
    static OctagonManager manager;

    @BeforeClass
    public static void setUpBeforeClass() {
        manager = new OctagonFloatManager();
    }

    @Test
    public void testNum_Int() {
        NumArray num = manager.init_num_t(1);
        manager.num_set_int(num, 0, 3L);
        Truth.assertThat((Boolean)manager.num_infty(num, 0)).isFalse();
        Truth.assertThat((Long)manager.num_get_int(num, 0)).isEqualTo((Object)3);
        Truth.assertThat((Double)manager.num_get_float(num, 0)).isWithin(0.0).of(3.0);
    }

    @Test
    public void testNum_Float() {
        NumArray num = manager.init_num_t(1);
        manager.num_set_float(num, 0, 3.3);
        Truth.assertThat((Boolean)manager.num_infty(num, 0)).isFalse();
        Truth.assertThat((Long)manager.num_get_int(num, 0)).isEqualTo((Object)3);
        Truth.assertThat((Double)manager.num_get_float(num, 0)).isWithin(0.0).of(3.3);
    }
}

