/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.pixelexport;

import com.google.common.collect.Iterators;
import com.google.common.truth.Truth;
import java.util.Iterator;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.pixelexport.DummyNode;
import org.sosy_lab.cpachecker.util.pixelexport.GraphLevel;
import org.sosy_lab.cpachecker.util.pixelexport.GraphStructure;
import org.sosy_lab.cpachecker.util.pixelexport.GraphToPixelsWriter;
import org.sosy_lab.cpachecker.util.pixelexport.SimpleGraphLevel;

public class GraphToPixelsWriterTest
extends GraphToPixelsWriter<DummyNode> {
    public GraphToPixelsWriterTest() throws InvalidConfigurationException {
        super(Configuration.defaultConfiguration());
    }

    @Override
    public SimpleGraphLevel.Builder<DummyNode> getLevelBuilder() {
        return new SimpleGraphLevel.Builder<DummyNode>();
    }

    @Override
    public Iterable<DummyNode> getChildren(DummyNode pParent) {
        return pParent.getChildren();
    }

    @Test
    public void getStructureTest1() {
        DummyNode root = new DummyNode();
        root.addChild(root);
        GraphStructure result = this.getStructure(root);
        int nLevels = Iterators.size(result.iterator());
        Truth.assertThat((Integer)nLevels).isEqualTo((Object)1);
        Truth.assertThat((Integer)result.iterator().next().getWidth()).isEqualTo((Object)1);
    }

    @Test
    public void getStructureTest2() {
        DummyNode root = new DummyNode();
        root.addChild(root);
        DummyNode[] nodes = new DummyNode[6];
        for (int i = 0; i < 6; ++i) {
            nodes[i] = new DummyNode();
        }
        root.addChild(nodes[0]);
        root.addChild(nodes[0]);
        root.addChild(nodes[1]);
        nodes[0].addChild(nodes[2]);
        nodes[1].addChild(nodes[2]);
        nodes[2].addChild(nodes[3]);
        nodes[2].addChild(nodes[4]);
        nodes[2].addChild(nodes[5]);
        GraphStructure result = this.getStructure(root);
        int nLevels = Iterators.size(result.iterator());
        Truth.assertThat((Integer)nLevels).isEqualTo((Object)4);
        int[] expectedNodesPerLayer = new int[]{1, 2, 1, 3};
        Iterator<GraphLevel> actualLevels = result.iterator();
        for (int expectedNodes : expectedNodesPerLayer) {
            Truth.assertThat((Integer)actualLevels.next().getWidth()).isEqualTo((Object)expectedNodes);
        }
    }
}

