/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.pixelexport;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.awt.Color;
import java.util.Collection;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.pixelexport.GraphLevel;
import org.sosy_lab.cpachecker.util.pixelexport.GraphToPixelsWriter;

public class SimpleGraphLevel
implements GraphLevel {
    private final int width;

    public SimpleGraphLevel(int pWidth) {
        Preconditions.checkArgument((pWidth >= 0 ? 1 : 0) != 0);
        this.width = pWidth;
    }

    @Override
    public Color getBackgroundColor() {
        return GraphToPixelsWriter.COLOR_BACKGROUND;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public Collection<Pair<ImmutableIntArray, Color>> getGroups() {
        return ImmutableList.of();
    }

    public static class Builder<NodeType>
    implements GraphLevel.Builder<NodeType> {
        private int width = 0;

        @Override
        public SimpleGraphLevel build() {
            return new SimpleGraphLevel(this.width);
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<NodeType> node() {
            ++this.width;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<NodeType> addMarkings(NodeType pNode) {
            return this;
        }
    }
}

