/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class AbstractionFormula
implements Serializable {
    private static final long serialVersionUID = -7756517128231447937L;
    private final transient @Nullable Region region;
    private final transient BooleanFormula formula;
    private final BooleanFormula instantiatedFormula;
    private final PathFormula blockFormula;
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final transient int id = idGenerator.getFreshId();
    private final transient FormulaManagerView fMgr;
    private final transient ImmutableSet<Integer> idsOfStoredAbstractionReused;

    public AbstractionFormula(FormulaManagerView mgr, Region pRegion, BooleanFormula pFormula, BooleanFormula pInstantiatedFormula, PathFormula pBlockFormula, Set<Integer> pIdOfStoredAbstractionReused) {
        this.fMgr = (FormulaManagerView)Preconditions.checkNotNull((Object)mgr);
        this.region = (Region)Preconditions.checkNotNull((Object)pRegion);
        this.formula = (BooleanFormula)Preconditions.checkNotNull((Object)pFormula);
        this.instantiatedFormula = (BooleanFormula)Preconditions.checkNotNull((Object)pInstantiatedFormula);
        this.blockFormula = (PathFormula)Preconditions.checkNotNull((Object)pBlockFormula);
        this.idsOfStoredAbstractionReused = ImmutableSet.copyOf(pIdOfStoredAbstractionReused);
    }

    public AbstractionFormula copyOf() {
        return new AbstractionFormula(this.fMgr, this.region, this.formula, this.instantiatedFormula, this.blockFormula, (Set<Integer>)this.idsOfStoredAbstractionReused);
    }

    public boolean isReusedFromStoredAbstraction() {
        return !this.idsOfStoredAbstractionReused.isEmpty();
    }

    public boolean isTrue() {
        return this.fMgr.getBooleanFormulaManager().isTrue(this.formula);
    }

    public boolean isFalse() {
        return this.fMgr.getBooleanFormulaManager().isFalse(this.formula);
    }

    public @Nullable Region asRegion() {
        return this.region;
    }

    public BooleanFormula asFormula() {
        return this.formula;
    }

    public BooleanFormula asFormulaFromOtherSolver(FormulaManagerView pMgr) {
        if (pMgr == this.fMgr) {
            return this.formula;
        }
        return pMgr.translateFrom(this.formula, this.fMgr);
    }

    public ExpressionTree<Object> asExpressionTree(CFANode pLocation) throws InterruptedException {
        return ExpressionTrees.fromFormula(this.asFormula(), this.fMgr, pLocation);
    }

    public BooleanFormula asInstantiatedFormula() {
        return this.instantiatedFormula;
    }

    public PathFormula getBlockFormula() {
        return this.blockFormula;
    }

    public int getId() {
        return this.id;
    }

    public ImmutableSet<Integer> getIdsOfStoredAbstractionReused() {
        return this.idsOfStoredAbstractionReused;
    }

    public String toString() {
        String abs = "";
        if (this.isTrue()) {
            abs = ": true";
        } else if (this.isFalse()) {
            abs = ": false";
        }
        return "ABS" + this.id + abs;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 2349286L;
        private final String instantiatedFormulaDump;
        private final PathFormula blockFormula;

        public SerializationProxy(AbstractionFormula pAbstractionFormula) {
            FormulaManagerView mgr = GlobalInfo.getInstance().getPredicateFormulaManagerView();
            this.instantiatedFormulaDump = mgr.dumpFormula(pAbstractionFormula.asInstantiatedFormula()).toString();
            this.blockFormula = pAbstractionFormula.getBlockFormula();
        }

        private Object readResolve() {
            FormulaManagerView mgr = GlobalInfo.getInstance().getPredicateFormulaManagerView();
            BooleanFormula instantiatedFormula = mgr.parse(this.instantiatedFormulaDump);
            BooleanFormula notInstantiated = mgr.uninstantiate(instantiatedFormula);
            return new AbstractionFormula(mgr, GlobalInfo.getInstance().getAbstractionManager().convertFormulaToRegion(notInstantiated), notInstantiated, instantiatedFormula, this.blockFormula, (Set<Integer>)ImmutableSet.of());
        }
    }
}

