/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate")
public final class AbstractionManager {
    private final LogManager logger;
    private final RegionManager rmgr;
    private final FormulaManagerView fmgr;
    private final Map<Region, AbstractionPredicate> absVarToPredicate = new HashMap<Region, AbstractionPredicate>();
    private final Map<BooleanFormula, AbstractionPredicate> symbVarToPredicate = new HashMap<BooleanFormula, AbstractionPredicate>();
    private final Map<BooleanFormula, AbstractionPredicate> atomToPredicate = new HashMap<BooleanFormula, AbstractionPredicate>();
    @Option(secure=true, name="abs.predicateOrdering.method", description="Predicate ordering")
    private PredicateOrderingStrategy varOrderMethod = PredicateOrderingStrategy.CHRONOLOGICAL;
    private final Map<Region, BooleanFormula> toConcreteCache;
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Class is not thread-safe, but concurrent read access to this variable is needed for the MBean")
    private volatile int numberOfPredicates = 0;
    @Option(secure=true, name="abs.useCache", description="use caching of region to formula conversions")
    private boolean useCache = true;
    private BooleanFormulaManagerView bfmgr;

    public AbstractionManager(RegionManager pRmgr, Configuration config, LogManager pLogger, Solver pSolver) throws InvalidConfigurationException {
        config.inject((Object)this, AbstractionManager.class);
        this.logger = pLogger;
        this.rmgr = pRmgr;
        this.fmgr = pSolver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.toConcreteCache = this.useCache ? new HashMap<Region, BooleanFormula>() : null;
        new AbstractionPredicatesMBean().register();
    }

    public int getNumberOfPredicates() {
        return this.numberOfPredicates;
    }

    public AbstractionPredicate makePredicate(BooleanFormula atom) {
        AbstractionPredicate result = this.atomToPredicate.get(atom);
        if (result == null) {
            Preconditions.checkArgument((boolean)atom.equals(this.fmgr.uninstantiate(atom)), (String)"Regions and AbstractionPredicates should always represent uninstantiated formula, but attempting to create predicate for instantiated formula %s", (Object)atom);
            BooleanFormula symbVar = this.fmgr.createPredicateVariable("PRED" + this.numberOfPredicates);
            Region absVar = this.rmgr instanceof SymbolicRegionManager ? ((SymbolicRegionManager)this.rmgr).createPredicate(atom) : this.rmgr.createPredicate();
            this.logger.log(Level.FINEST, new Object[]{"Created predicate", absVar, "from variable", symbVar, "and atom", atom});
            result = new AbstractionPredicate(absVar, symbVar, atom);
            this.symbVarToPredicate.put(symbVar, result);
            this.absVarToPredicate.put(absVar, result);
            this.atomToPredicate.put(atom, result);
            ++this.numberOfPredicates;
        }
        return result;
    }

    public void reorderPredicates() {
        if (this.varOrderMethod != PredicateOrderingStrategy.CHRONOLOGICAL) {
            this.rmgr.reorder((RegionManager.VariableOrderingStrategy)((Object)Verify.verifyNotNull((Object)((Object)this.varOrderMethod.frameworkStrategy))));
        }
    }

    public AbstractionPredicate makeFalsePredicate() {
        return this.makePredicate(this.bfmgr.makeFalse());
    }

    public AbstractionPredicate getPredicate(BooleanFormula var) {
        AbstractionPredicate result = this.symbVarToPredicate.get(var);
        if (result == null) {
            throw new IllegalArgumentException(var + " seems not to be a formula corresponding to a single predicate variable.");
        }
        return result;
    }

    public BooleanFormula convertRegionToFormula(Region af) {
        if (this.rmgr instanceof SymbolicRegionManager) {
            return ((SymbolicRegionManager)this.rmgr).toFormula(af);
        }
        Map<Region, BooleanFormula> cache = this.useCache ? this.toConcreteCache : new HashMap<Region, BooleanFormula>();
        ArrayDeque<Region> toProcess = new ArrayDeque<Region>();
        cache.put(this.rmgr.makeTrue(), this.bfmgr.makeTrue());
        cache.put(this.rmgr.makeFalse(), this.bfmgr.makeFalse());
        toProcess.push(af);
        while (!toProcess.isEmpty()) {
            Region n = (Region)toProcess.peek();
            if (cache.containsKey(n)) {
                toProcess.pop();
                continue;
            }
            boolean childrenDone = true;
            BooleanFormula m1 = null;
            BooleanFormula m2 = null;
            Triple<Region, Region, Region> parts = this.rmgr.getIfThenElse(n);
            Region c1 = parts.getSecond();
            Region c2 = parts.getThird();
            if (!cache.containsKey(c1)) {
                toProcess.push(c1);
                childrenDone = false;
            } else {
                m1 = cache.get(c1);
            }
            if (!cache.containsKey(c2)) {
                toProcess.push(c2);
                childrenDone = false;
            } else {
                m2 = cache.get(c2);
            }
            if (!childrenDone) continue;
            assert (m1 != null);
            assert (m2 != null);
            toProcess.pop();
            Region var = parts.getFirst();
            AbstractionPredicate pred = this.absVarToPredicate.get(var);
            assert (pred != null) : var;
            BooleanFormula atom = pred.getSymbolicAtom();
            if (this.bfmgr.isTrue(m1)) {
                if (this.bfmgr.isFalse(m2)) {
                    cache.put(n, atom);
                    continue;
                }
                cache.put(n, this.bfmgr.or(atom, m2));
                continue;
            }
            if (this.bfmgr.isFalse(m1)) {
                if (this.bfmgr.isTrue(m2)) {
                    cache.put(n, this.bfmgr.not(atom));
                    continue;
                }
                cache.put(n, this.bfmgr.and(this.bfmgr.not(atom), m2));
                continue;
            }
            if (this.bfmgr.isTrue(m2)) {
                cache.put(n, this.bfmgr.or(this.bfmgr.not(atom), m1));
                continue;
            }
            if (this.bfmgr.isFalse(m2)) {
                cache.put(n, this.bfmgr.and(atom, m1));
                continue;
            }
            cache.put(n, this.bfmgr.ifThenElse(atom, m1, m2));
        }
        BooleanFormula result = cache.get(af);
        assert (result != null);
        return result;
    }

    public boolean entails(Region f1, Region f2) throws SolverException, InterruptedException {
        return this.rmgr.entails(f1, f2);
    }

    public Set<AbstractionPredicate> extractPredicates(Region af) {
        HashSet<AbstractionPredicate> vars = new HashSet<AbstractionPredicate>();
        ArrayDeque<Region> toProcess = new ArrayDeque<Region>();
        toProcess.push(af);
        while (!toProcess.isEmpty()) {
            Region n = (Region)toProcess.pop();
            if (n.isTrue() || n.isFalse()) continue;
            AbstractionPredicate pred = this.absVarToPredicate.get(n);
            if (pred == null) {
                Triple<Region, Region, Region> parts = this.rmgr.getIfThenElse(n);
                Region var = parts.getFirst();
                pred = this.absVarToPredicate.get(var);
                assert (pred != null);
                toProcess.push(parts.getSecond());
                toProcess.push(parts.getThird());
            }
            vars.add(pred);
        }
        return vars;
    }

    public Region convertFormulaToRegion(BooleanFormula pF) {
        return this.rmgr.fromFormula(pF, this.fmgr, atom -> {
            if (this.atomToPredicate.containsKey(atom)) {
                return this.atomToPredicate.get(atom).getAbstractVariable();
            }
            return this.makePredicate((BooleanFormula)atom).getAbstractVariable();
        });
    }

    public RegionManager getRegionCreator() {
        return this.rmgr;
    }

    private class AbstractionPredicatesMBean
    extends AbstractMBean
    implements AbstractionPredicatesMXBean {
        public AbstractionPredicatesMBean() {
            super("org.sosy_lab.cpachecker:type=predicate,name=AbstractionPredicates", AbstractionManager.this.logger);
        }

        @Override
        public int getNumberOfPredicates() {
            return AbstractionManager.this.numberOfPredicates;
        }

        @Override
        public String getPredicates() {
            return Joiner.on((char)'\n').join(AbstractionManager.this.absVarToPredicate.values());
        }
    }

    public static interface AbstractionPredicatesMXBean {
        public int getNumberOfPredicates();

        public String getPredicates();
    }

    private static enum PredicateOrderingStrategy {
        CHRONOLOGICAL(null),
        FRAMEWORK_RANDOM(RegionManager.VariableOrderingStrategy.RANDOM),
        FRAMEWORK_SIFT(RegionManager.VariableOrderingStrategy.SIFT),
        FRAMEWORK_SIFTITE(RegionManager.VariableOrderingStrategy.SIFTITE),
        FRAMEWORK_WIN2(RegionManager.VariableOrderingStrategy.WIN2),
        FRAMEWORK_WIN2ITE(RegionManager.VariableOrderingStrategy.WIN2ITE),
        FRAMEWORK_WIN3(RegionManager.VariableOrderingStrategy.WIN3),
        FRAMEWORK_WIN3ITE(RegionManager.VariableOrderingStrategy.WIN3ITE);

        final @Nullable RegionManager.VariableOrderingStrategy frameworkStrategy;

        private PredicateOrderingStrategy(RegionManager.VariableOrderingStrategy pFrameworkStrategy) {
            this.frameworkStrategy = pFrameworkStrategy;
        }
    }
}

