/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.ACastExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteExpressionEvaluator;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.counterexample.FieldReference;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.core.counterexample.MemoryName;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.Model;

public class AssignmentToPathAllocator {
    private static final int IS_NOT_GLOBAL = 2;
    private static final int NAME_AND_FUNCTION = 0;
    private static final int IS_FIELD_REFERENCE = 1;
    private final ShutdownNotifier shutdownNotifier;
    private final AssumptionToEdgeAllocator assumptionToEdgeAllocator;
    private final MemoryName memoryName;
    private final MachineModel machineModel;

    public AssignmentToPathAllocator(Configuration pConfig, ShutdownNotifier pShutdownNotifier, LogManager pLogger, MachineModel pMachineModel) throws InvalidConfigurationException {
        this.shutdownNotifier = pShutdownNotifier;
        this.assumptionToEdgeAllocator = AssumptionToEdgeAllocator.create(pConfig, pLogger, pMachineModel);
        this.machineModel = pMachineModel;
        TypeHandlerWithPointerAliasing typeHandler = new TypeHandlerWithPointerAliasing(pLogger, pMachineModel, new FormulaEncodingWithPointerAliasingOptions(pConfig));
        this.memoryName = exp -> typeHandler.getPointerAccessNameForType(typeHandler.getSimplifiedType(exp));
    }

    public CFAPathWithAssumptions allocateAssignmentsToPath(ARGPath pPath, Iterable<Model.ValueAssignment> pModel, List<SSAMap> pSSAMaps) throws InterruptedException {
        ConcreteStatePath concreteStatePath = this.createConcreteStatePath(pPath, pModel, pSSAMaps);
        return CFAPathWithAssumptions.of(concreteStatePath, this.assumptionToEdgeAllocator);
    }

    private ConcreteStatePath createConcreteStatePath(ARGPath pPath, Iterable<Model.ValueAssignment> pModel, List<SSAMap> pSSAMaps) throws InterruptedException {
        ConcreteExpressionEvaluator evaluator = this.createPredicateAnalysisEvaluator(pModel);
        AssignableTermsInPath assignableTerms = this.assignTermsToPathPosition(pSSAMaps, pModel);
        ImmutableList.Builder pathWithAssignments = ImmutableList.builderWithExpectedSize((int)pPath.getInnerEdges().size());
        ImmutableMap<LeftHandSide, Address> addressOfVariables = this.getVariableAddresses(assignableTerms);
        LinkedHashMap<String, Model.ValueAssignment> variableEnvironment = new LinkedHashMap<String, Model.ValueAssignment>();
        LinkedHashMap<LeftHandSide, Object> variables = new LinkedHashMap<LeftHandSide, Object>();
        LinkedHashMultimap functionEnvironment = LinkedHashMultimap.create();
        LinkedHashMap<String, Map<Address, Object>> memory = new LinkedHashMap<String, Map<Address, Object>>();
        int ssaMapIndex = 0;
        PathIterator pathIt = pPath.fullPathIterator();
        while (pathIt.hasNext()) {
            boolean isInsideMultiEdge;
            this.shutdownNotifier.shutdownIfNecessary();
            CFAEdge cfaEdge = pathIt.getOutgoingEdge();
            ImmutableSet terms = assignableTerms.getAssignableTermsAtPosition().get((Object)ssaMapIndex);
            SSAMap ssaMap = pSSAMaps.get(ssaMapIndex);
            if (pathIt.hasNext()) {
                pathIt.advance();
                isInsideMultiEdge = !pathIt.isPositionWithState();
                pathIt.rewind();
            } else {
                isInsideMultiEdge = false;
            }
            this.createAssignments((ImmutableCollection<Model.ValueAssignment>)terms, variableEnvironment, variables, (Multimap<String, Model.ValueAssignment>)functionEnvironment, memory);
            this.removeDeallocatedVariables(ssaMap, variableEnvironment, variables);
            ImmutableMap allocatedMemory = ImmutableMap.copyOf((Map)Maps.transformEntries(memory, (name, heap) -> new Memory((String)name, (Map<Address, Object>)heap)));
            ConcreteState concreteState = new ConcreteState((Map<LeftHandSide, Object>)variables, (Map<String, Memory>)allocatedMemory, (Map<LeftHandSide, Address>)addressOfVariables, this.memoryName, evaluator, this.machineModel);
            ConcreteStatePath.SingleConcreteState singleConcreteState = isInsideMultiEdge ? new ConcreteStatePath.IntermediateConcreteState(cfaEdge, concreteState) : new ConcreteStatePath.SingleConcreteState(cfaEdge, concreteState);
            pathWithAssignments.add((Object)singleConcreteState);
            ++ssaMapIndex;
            pathIt.advance();
        }
        return new ConcreteStatePath((List<ConcreteStatePath.ConcreteStatePathNode>)pathWithAssignments.build());
    }

    private ConcreteExpressionEvaluator createPredicateAnalysisEvaluator(Iterable<Model.ValueAssignment> pModel) {
        ImmutableListMultimap uninterpretedFunctions = FluentIterable.from(pModel).filter(Model.ValueAssignment::isFunction).index(Model.ValueAssignment::getName);
        return new PredicateAnalysisConcreteExpressionEvaluator((Multimap<String, Model.ValueAssignment>)uninterpretedFunctions);
    }

    private LeftHandSide createLeftHandSide(String pTermName) {
        String name;
        boolean isReference;
        ImmutableList references = ImmutableList.copyOf((Iterable)Splitter.on((char)'$').split((CharSequence)pTermName));
        String nameAndFunctionAsString = (String)references.get(0);
        ImmutableList nameAndFunction = ImmutableList.copyOf((Iterable)Splitter.on((String)"::").split((CharSequence)nameAndFunctionAsString));
        String function = null;
        boolean isNotGlobal = nameAndFunction.size() == 2;
        boolean bl = isReference = references.size() > 1;
        if (isNotGlobal) {
            function = (String)nameAndFunction.get(0);
            name = (String)nameAndFunction.get(1);
        } else {
            name = (String)nameAndFunction.get(0);
        }
        if (isReference) {
            ArrayList<String> fieldNames = new ArrayList<String>(references.size() - 1);
            Iterator fieldNameIterator = references.iterator();
            int i = 0;
            while (fieldNameIterator.hasNext()) {
                String fieldName = (String)fieldNameIterator.next();
                if (i != 0) {
                    fieldNames.add(fieldName);
                }
                ++i;
            }
            if (isNotGlobal) {
                return new FieldReference(name, function, fieldNames);
            }
            return new FieldReference(name, fieldNames);
        }
        if (isNotGlobal) {
            return new IDExpression(name, function);
        }
        return new IDExpression(name);
    }

    private void removeDeallocatedVariables(SSAMap pMap, Map<String, Model.ValueAssignment> variableEnvironment, Map<LeftHandSide, Object> variables) {
        variableEnvironment.keySet().removeIf(name -> pMap.getIndex((String)name) < 0);
        variables.keySet().removeIf(lhs -> pMap.getIndex(lhs.toString()) < 0);
    }

    private void createAssignments(ImmutableCollection<Model.ValueAssignment> terms, Map<String, Model.ValueAssignment> variableEnvironment, Map<LeftHandSide, Object> pVariables, Multimap<String, Model.ValueAssignment> functionEnvironment, Map<String, Map<Address, Object>> memory) {
        for (Model.ValueAssignment term : terms) {
            String name = term.getName();
            if (term.isFunction()) {
                if (functionEnvironment.containsKey((Object)name)) {
                    boolean replaced = false;
                    HashSet assignments = new HashSet(functionEnvironment.get((Object)name));
                    for (Model.ValueAssignment oldAssignment : assignments) {
                        if (!this.isSmallerSSA(oldAssignment, term)) continue;
                        functionEnvironment.remove((Object)name, (Object)oldAssignment);
                        functionEnvironment.put((Object)name, (Object)term);
                        replaced = true;
                        this.addHeapValue(memory, term);
                    }
                    if (replaced) continue;
                    functionEnvironment.put((Object)name, (Object)term);
                    this.addHeapValue(memory, term);
                    continue;
                }
                functionEnvironment.put((Object)name, (Object)term);
                this.addHeapValue(memory, term);
                continue;
            }
            Pair<String, OptionalInt> pair = FormulaManagerView.parseName(name);
            if (!pair.getSecond().isPresent()) continue;
            String canonicalName = pair.getFirst();
            int newIndex = pair.getSecond().orElseThrow();
            if (variableEnvironment.containsKey(canonicalName)) {
                Model.ValueAssignment oldVariable = variableEnvironment.get(canonicalName);
                int oldIndex = FormulaManagerView.parseName(oldVariable.getName()).getSecond().orElseThrow();
                if (oldIndex >= newIndex) continue;
                variableEnvironment.put(canonicalName, term);
                LeftHandSide lhs = this.createLeftHandSide(canonicalName);
                pVariables.put(lhs, term.getValue());
                continue;
            }
            variableEnvironment.put(canonicalName, term);
            LeftHandSide lhs = this.createLeftHandSide(canonicalName);
            pVariables.put(lhs, term.getValue());
        }
    }

    private void addHeapValue(Map<String, Map<Address, Object>> memory, Model.ValueAssignment pFunctionAssignment) {
        String heapName = this.getName(pFunctionAssignment);
        Map<Address, Object> heap = memory.get(heapName);
        if (heap == null) {
            heap = new LinkedHashMap<Address, Object>();
            memory.put(heapName, heap);
        }
        Address address = Address.valueOf(Iterables.getOnlyElement((Iterable)pFunctionAssignment.getArgumentsInterpretation()));
        Object value = pFunctionAssignment.getValue();
        heap.put(address, value);
    }

    private ImmutableMap<LeftHandSide, Address> getVariableAddresses(AssignableTermsInPath assignableTerms) {
        ImmutableMap.Builder addressOfVariables = ImmutableMap.builder();
        for (Model.ValueAssignment constant : assignableTerms.getConstants()) {
            String name = FormulaManagerView.parseName(constant.getName()).getFirst();
            if (!PointerTargetSet.isBaseName(name)) continue;
            assert (FormulaManagerView.parseName(constant.getName()).getSecond().isEmpty());
            if (PointerTargetSet.isMallocBase(name)) continue;
            Address address = Address.valueOf(constant.getValue());
            String constantName = PointerTargetSet.getBase(name);
            LeftHandSide leftHandSide = this.createLeftHandSide(constantName);
            addressOfVariables.put((Object)leftHandSide, (Object)address);
        }
        return addressOfVariables.buildOrThrow();
    }

    private boolean isSmallerSSA(Model.ValueAssignment pOldFunction, Model.ValueAssignment pFunction) {
        int oldArity;
        String oldName;
        String name = FormulaManagerView.parseName(pFunction.getName()).getFirstNotNull();
        if (!name.equals(oldName = FormulaManagerView.parseName(pOldFunction.getName()).getFirstNotNull())) {
            return false;
        }
        int ssa = this.getSSAIndex(pFunction);
        int oldSSA = this.getSSAIndex(pOldFunction);
        if (oldSSA > ssa) {
            return false;
        }
        int arity = pFunction.getArgumentsInterpretation().size();
        if (arity != (oldArity = pOldFunction.getArgumentsInterpretation().size())) {
            return false;
        }
        for (int c = 0; c < arity; ++c) {
            if (pOldFunction.getArgumentsInterpretation().get(c).equals(pFunction.getArgumentsInterpretation().get(c))) continue;
            return false;
        }
        return true;
    }

    private AssignableTermsInPath assignTermsToPathPosition(List<SSAMap> pSsaMaps, Iterable<Model.ValueAssignment> pModel) {
        ImmutableSetMultimap.Builder assignedTermsPosition = ImmutableSetMultimap.builder();
        ImmutableSet.Builder constants = ImmutableSet.builder();
        ImmutableSet.Builder functionsWithoutSSAIndex = ImmutableSet.builder();
        for (Model.ValueAssignment term : pModel) {
            int index;
            int ssaIdx = this.getSSAIndex(term);
            if (term.isFunction()) {
                if (ssaIdx == -2) {
                    functionsWithoutSSAIndex.add((Object)term);
                    continue;
                }
                index = this.findFirstOccurrenceOf(term, pSsaMaps);
                if (index < 0) continue;
                assignedTermsPosition.put((Object)index, (Object)term);
                continue;
            }
            if (ssaIdx != -2) {
                index = this.findFirstOccurrenceOf(term, pSsaMaps);
                if (index < 0) continue;
                assignedTermsPosition.put((Object)index, (Object)term);
                continue;
            }
            constants.add((Object)term);
        }
        return new AssignableTermsInPath((ImmutableSetMultimap<Integer, Model.ValueAssignment>)assignedTermsPosition.build(), (ImmutableSet<Model.ValueAssignment>)constants.build(), (ImmutableSet<Model.ValueAssignment>)functionsWithoutSSAIndex.build());
    }

    private int getSSAIndex(Model.ValueAssignment pTerm) {
        return FormulaManagerView.parseName(pTerm.getName()).getSecond().orElse(-2);
    }

    private String getName(Model.ValueAssignment pTerm) {
        return FormulaManagerView.parseName(pTerm.getName()).getFirst();
    }

    int findFirstOccurrenceOf(Model.ValueAssignment pVar, List<SSAMap> pSsaMaps) {
        int result = -1;
        String canonicalName = this.getName(pVar);
        int varSSAIdx = this.getSSAIndex(pVar);
        for (SSAMap map : pSsaMaps) {
            ++result;
            int ssaIndex = map.getIndex(canonicalName);
            if (ssaIndex != varSSAIdx) continue;
            return result;
        }
        return result;
    }

    private static final class AssignableTermsInPath {
        private final ImmutableSetMultimap<Integer, Model.ValueAssignment> assignableTermsAtPosition;
        private final ImmutableSet<Model.ValueAssignment> constants;
        private final ImmutableSet<Model.ValueAssignment> ufFunctionsWithoutSSAIndex;

        public AssignableTermsInPath(ImmutableSetMultimap<Integer, Model.ValueAssignment> pAssignableTermsAtPosition, ImmutableSet<Model.ValueAssignment> pConstants, ImmutableSet<Model.ValueAssignment> pUfFunctionsWithoutSSAIndex) {
            this.assignableTermsAtPosition = pAssignableTermsAtPosition;
            this.constants = pConstants;
            this.ufFunctionsWithoutSSAIndex = pUfFunctionsWithoutSSAIndex;
        }

        public ImmutableSetMultimap<Integer, Model.ValueAssignment> getAssignableTermsAtPosition() {
            return this.assignableTermsAtPosition;
        }

        public ImmutableSet<Model.ValueAssignment> getConstants() {
            return this.constants;
        }

        public ImmutableSet<Model.ValueAssignment> getUfFunctionsWithoutSSAIndex() {
            return this.ufFunctionsWithoutSSAIndex;
        }

        public String toString() {
            return "AssignableTermsInPath\nassignableTermsAtPosition=" + this.assignableTermsAtPosition + "\n constants=" + this.constants + "\nufFunctionsWithoutSSAIndex=" + this.ufFunctionsWithoutSSAIndex;
        }
    }

    private static class PredicateAnalysisConcreteExpressionEvaluator
    implements ConcreteExpressionEvaluator {
        private final Multimap<String, Model.ValueAssignment> uninterpretedFunctions;

        public PredicateAnalysisConcreteExpressionEvaluator(Multimap<String, Model.ValueAssignment> pUninterpretedFunction) {
            this.uninterpretedFunctions = pUninterpretedFunction;
        }

        @Override
        public boolean shouldEvaluateExpressionWithThisEvaluator(AExpression pExp) {
            CExpression cExp;
            if (pExp instanceof CExpression && this.hasUninterpretedFunctionName(cExp = (CExpression)pExp)) {
                String functionName = this.getUninterpretedFunctionName(cExp);
                return this.uninterpretedFunctions.containsKey((Object)functionName);
            }
            return false;
        }

        private String getUninterpretedFunctionName(CExpression pCExp) {
            String typeName = this.getTypeString(pCExp.getExpressionType());
            if (pCExp instanceof CBinaryExpression) {
                CBinaryExpression binExp = (CBinaryExpression)pCExp;
                Object opString = binExp.getOperator().getOperator();
                switch (binExp.getOperator()) {
                    case MULTIPLY: 
                    case MODULO: 
                    case DIVIDE: {
                        opString = "_" + (String)opString;
                        break;
                    }
                }
                return typeName + "_" + (String)opString + "_";
            }
            if (pCExp instanceof CUnaryExpression) {
                CUnaryExpression unExp = (CUnaryExpression)pCExp;
                String op = unExp.getOperator().getOperator();
                return typeName + "_" + op + "_";
            }
            if (pCExp instanceof CCastExpression) {
                CCastExpression castExp = (CCastExpression)pCExp;
                CType type2 = castExp.getOperand().getExpressionType();
                String typeName2 = this.getTypeString(type2);
                return "__cast_" + typeName2 + "_to_" + typeName + "__";
            }
            return "";
        }

        private String getTypeString(CType pExpressionType) {
            if (pExpressionType instanceof CSimpleType) {
                CSimpleType simpleType = (CSimpleType)pExpressionType;
                switch (simpleType.getType()) {
                    case INT: 
                    case CHAR: 
                    case BOOL: {
                        return "Integer";
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return "Rational";
                    }
                }
                return "";
            }
            return "";
        }

        private boolean hasUninterpretedFunctionName(CExpression pCExp) {
            return pCExp instanceof CBinaryExpression || pCExp instanceof CUnaryExpression || pCExp instanceof CCastExpression;
        }

        @Override
        public Value evaluate(ABinaryExpression pBinExp, Value pOp1, Value pOp2) {
            CBinaryExpression cBinExp = (CBinaryExpression)pBinExp;
            String functionName = this.getUninterpretedFunctionName(cBinExp);
            Value[] operands = new Value[]{pOp1, pOp2};
            for (Model.ValueAssignment valueAssignment : this.uninterpretedFunctions.get((Object)functionName)) {
                if (!this.matchOperands(valueAssignment, operands)) continue;
                return this.asValue(valueAssignment.getValue());
            }
            return Value.UnknownValue.getInstance();
        }

        private boolean matchOperands(Model.ValueAssignment pValueAssignment, Value[] operands) {
            ImmutableList arguments = pValueAssignment.getArgumentsInterpretation();
            if (arguments.size() != operands.length) {
                return false;
            }
            for (int i = 0; i < operands.length; ++i) {
                Value operandI = operands[i];
                Value argumentI = this.asValue(arguments.get(i));
                if (argumentI.equals(operandI)) continue;
                return false;
            }
            return true;
        }

        private Value asValue(Object pValue) {
            if (!(pValue instanceof Number)) {
                return Value.UnknownValue.getInstance();
            }
            return new NumericValue((Number)pValue);
        }

        @Override
        public Value evaluate(AUnaryExpression pUnaryExpression, Value pOperand) {
            if (!pOperand.isNumericValue()) {
                return Value.UnknownValue.getInstance();
            }
            CUnaryExpression cUnaryExp = (CUnaryExpression)pUnaryExpression;
            String functionName = this.getUninterpretedFunctionName(cUnaryExp);
            Value[] operands = new Value[]{pOperand};
            for (Model.ValueAssignment valueAssignment : this.uninterpretedFunctions.get((Object)functionName)) {
                if (!this.matchOperands(valueAssignment, operands)) continue;
                return this.asValue(valueAssignment.getValue());
            }
            return Value.UnknownValue.getInstance();
        }

        @Override
        public Value evaluate(ACastExpression pCastExpression, Value pOperand) {
            if (!pOperand.isNumericValue()) {
                return Value.UnknownValue.getInstance();
            }
            CCastExpression cUnaryExp = (CCastExpression)pCastExpression;
            String functionName = this.getUninterpretedFunctionName(cUnaryExp);
            Value[] operands = new Value[]{pOperand};
            for (Model.ValueAssignment valueAssignment : this.uninterpretedFunctions.get((Object)functionName)) {
                if (!this.matchOperands(valueAssignment, operands)) continue;
                return this.asValue(valueAssignment.getValue());
            }
            return Value.UnknownValue.getInstance();
        }
    }
}

