/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.util.predicates.AssignmentToPathAllocator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;

public class AssignmentToPathAllocatorTest {
    private AssignmentToPathAllocator allocator;

    @Before
    public void setUp() throws InvalidConfigurationException {
        this.allocator = new AssignmentToPathAllocator(Configuration.defaultConfiguration(), ShutdownNotifier.createDummy(), LogManager.createTestLogManager(), MachineModel.LINUX32);
    }

    @Test
    public void testFindFirstOccurrenceOfVariable() {
        SSAMap.SSAMapBuilder ssaMapBuilder = SSAMap.emptySSAMap().builder();
        ArrayList<SSAMap> ssaMaps = new ArrayList<SSAMap>();
        ssaMaps.add(SSAMap.emptySSAMap());
        ssaMapBuilder.setIndex("x", CNumericTypes.INT, 4);
        ssaMaps.add(ssaMapBuilder.build());
        ssaMapBuilder.setIndex("y", CNumericTypes.INT, 5);
        ssaMapBuilder.setIndex("z", CNumericTypes.INT, 6);
        SSAMap ssaMap = ssaMapBuilder.build();
        ssaMaps.add(ssaMap);
        ssaMapBuilder.deleteVariable("z");
        ssaMaps.add(ssaMapBuilder.build());
        Model.ValueAssignment varX = new Model.ValueAssignment((Formula)Mockito.mock(Formula.class), (Formula)Mockito.mock(Formula.class), (BooleanFormula)Mockito.mock(BooleanFormula.class), FormulaManagerView.instantiateVariableName("x", ssaMap), (Object)1, (List)ImmutableList.of());
        Model.ValueAssignment varY = new Model.ValueAssignment((Formula)Mockito.mock(Formula.class), (Formula)Mockito.mock(Formula.class), (BooleanFormula)Mockito.mock(BooleanFormula.class), FormulaManagerView.instantiateVariableName("y", ssaMap), (Object)1, (List)ImmutableList.of());
        Model.ValueAssignment varZ = new Model.ValueAssignment((Formula)Mockito.mock(Formula.class), (Formula)Mockito.mock(Formula.class), (BooleanFormula)Mockito.mock(BooleanFormula.class), FormulaManagerView.instantiateVariableName("z", ssaMap), (Object)1, (List)ImmutableList.of());
        Truth.assertThat((Integer)this.allocator.findFirstOccurrenceOf(varX, ssaMaps)).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.allocator.findFirstOccurrenceOf(varY, ssaMaps)).isEqualTo((Object)2);
        Truth.assertThat((Integer)this.allocator.findFirstOccurrenceOf(varZ, ssaMaps)).isEqualTo((Object)2);
    }
}

