/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;

@Options(prefix="cpa.predicate.blk")
public class BlockOperator {
    @Option(secure=true, description="maximum blocksize before abstraction is forced\n(non-negative number, special values: 0 = don't check threshold, 1 = SBE)")
    @IntegerOption(min=0L)
    private int threshold = 0;
    @Option(secure=true, name="functions", description="abstractions at function calls/returns if threshold has been reached (no effect if threshold = 0)")
    private boolean absOnFunction = false;
    @Option(secure=true, name="loops", description="abstractions at loop heads if threshold has been reached (no effect if threshold = 0)")
    private boolean absOnLoop = false;
    @Option(secure=true, name="join", description="abstractions at CFA nodes with more than one incoming edge if threshold has been reached (no effect if threshold = 0)")
    private boolean absOnJoin = false;
    @Option(secure=true, description="force abstractions immediately after threshold is reached (no effect if threshold = 0)")
    private boolean alwaysAfterThreshold = true;
    @Option(secure=true, description="force abstractions at loop heads, regardless of threshold")
    private boolean alwaysAtLoops = true;
    @Option(secure=true, description="force abstractions at each function calls/returns, regardless of threshold")
    private boolean alwaysAtFunctions = true;
    @Option(secure=true, description="force abstractions at each function head (first node in the body), regardless of threshold")
    private boolean alwaysAtFunctionHeads = false;
    @Option(secure=true, description="force abstractions at the head of the analysis-entry function (first node in the body), regardless of threshold")
    private boolean alwaysAtEntryFunctionHead = false;
    @Option(secure=true, description="force abstractions at each function call (node before entering the body), regardless of threshold")
    private boolean alwaysAtFunctionCallNodes = false;
    @Option(secure=true, description="force abstractions at each join node, regardless of threshold")
    private boolean alwaysAtJoin = false;
    @Option(secure=true, description="force abstractions at each branch node, regardless of threshold")
    private boolean alwaysAtBranch = false;
    @Option(secure=true, description="force abstractions at program exit (program end, abort, etc.), regardless of threshold")
    private boolean alwaysAtProgramExit = false;
    @Option(secure=true, description="abstraction always and only on explicitly computed abstraction nodes.")
    private boolean alwaysAndOnlyAtExplicitNodes = false;
    @Option(secure=true, description="abstraction always at explicitly computed abstraction nodes.")
    private boolean alwaysAtExplicitNodes = false;
    private ImmutableSet<CFANode> explicitAbstractionNodes = null;
    private ImmutableSet<CFANode> loopHeads = null;
    public StatCounter numBlkEntryFunctionHeads = new StatCounter("");
    public StatCounter numBlkFunctionHeads = new StatCounter("");
    public StatCounter numBlkFunctions = new StatCounter("");
    public StatCounter numBlkLoops = new StatCounter("");
    public StatCounter numBlkJoins = new StatCounter("");
    public StatCounter numBlkBranch = new StatCounter("");
    public StatCounter numBlkThreshold = new StatCounter("");
    public StatCounter numBlkExit = new StatCounter("");

    public boolean isBlockEnd(CFANode loc, int thresholdValue) {
        if (this.alwaysAndOnlyAtExplicitNodes) {
            assert (this.explicitAbstractionNodes != null);
            return this.explicitAbstractionNodes.contains((Object)loc);
        }
        if (this.alwaysAtExplicitNodes && this.explicitAbstractionNodes != null && this.explicitAbstractionNodes.contains((Object)loc)) {
            return true;
        }
        if (this.threshold == 1) {
            return true;
        }
        if (this.alwaysAtFunctions && this.isFunctionCall(loc)) {
            this.numBlkFunctions.inc();
            return true;
        }
        if (this.alwaysAtEntryFunctionHead && BlockOperator.isFirstLocationInMainFunctionBody(loc)) {
            this.numBlkEntryFunctionHeads.inc();
            return true;
        }
        if (this.alwaysAtFunctionHeads && this.isFunctionHead(loc)) {
            this.numBlkFunctionHeads.inc();
            return true;
        }
        if (this.alwaysAtFunctionCallNodes && this.isBeforeFunctionCall(loc)) {
            this.numBlkFunctionHeads.inc();
            return true;
        }
        if (this.alwaysAtLoops && this.isLoopHead(loc)) {
            this.numBlkLoops.inc();
            return true;
        }
        if (this.alwaysAtJoin && this.isJoinNode(loc)) {
            this.numBlkJoins.inc();
            return true;
        }
        if (this.alwaysAtBranch && this.isBranchNode(loc)) {
            this.numBlkBranch.inc();
            return true;
        }
        if (this.alwaysAtProgramExit && this.isProgramExit(loc)) {
            this.numBlkExit.inc();
            return true;
        }
        if (this.threshold > 0) {
            if (this.isThresholdFulfilled(thresholdValue)) {
                if (this.alwaysAfterThreshold) {
                    this.numBlkThreshold.inc();
                    return true;
                }
                if (this.absOnFunction && this.isFunctionCall(loc)) {
                    this.numBlkThreshold.inc();
                    this.numBlkFunctions.inc();
                    return true;
                }
                if (this.absOnLoop && this.isLoopHead(loc)) {
                    this.numBlkThreshold.inc();
                    this.numBlkLoops.inc();
                    return true;
                }
                if (this.absOnJoin && this.isJoinNode(loc)) {
                    this.numBlkThreshold.inc();
                    this.numBlkJoins.inc();
                    return true;
                }
            }
        } else {
            assert (this.threshold == 0);
            if (this.absOnFunction && this.isFunctionCall(loc)) {
                this.numBlkFunctions.inc();
                return true;
            }
            if (this.absOnLoop && this.isLoopHead(loc)) {
                this.numBlkLoops.inc();
                return true;
            }
        }
        return false;
    }

    public boolean alwaysReturnsFalse() {
        if (this.alwaysAndOnlyAtExplicitNodes) {
            return this.explicitAbstractionNodes.isEmpty();
        }
        return !this.alwaysAtFunctions && !this.alwaysAtEntryFunctionHead && !this.alwaysAtFunctionCallNodes && !this.alwaysAtLoops && !this.alwaysAtJoin && !this.alwaysAtBranch && !this.alwaysAtProgramExit && (!this.alwaysAtExplicitNodes || this.explicitAbstractionNodes == null || this.explicitAbstractionNodes.isEmpty()) && this.threshold == 0 && !this.absOnFunction && !this.absOnLoop && !this.absOnJoin;
    }

    protected boolean isJoinNode(CFANode pSuccLoc) {
        return pSuccLoc.getNumEnteringEdges() > 1;
    }

    protected boolean isThresholdFulfilled(int thresholdValue) {
        return thresholdValue >= this.threshold;
    }

    protected boolean isLoopHead(CFANode succLoc) {
        Preconditions.checkState((this.loopHeads != null ? 1 : 0) != 0, (Object)"Missing loop information");
        return this.loopHeads.contains((Object)succLoc);
    }

    protected boolean isFunctionCall(CFANode succLoc) {
        return this.isFunctionHead(succLoc) || succLoc.getEnteringSummaryEdge() != null;
    }

    public void setExplicitAbstractionNodes(ImmutableSet<CFANode> pNodes) {
        this.explicitAbstractionNodes = pNodes;
    }

    public void setCFA(CFA cfa) {
        if ((this.absOnLoop || this.alwaysAtLoops) && cfa.getAllLoopHeads().isPresent()) {
            this.loopHeads = cfa.getAllLoopHeads().orElseThrow();
        }
    }

    protected boolean isBranchNode(CFANode pLoc) {
        return pLoc.getNumLeavingEdges() > 1;
    }

    protected boolean isFunctionHead(CFANode succLoc) {
        return succLoc instanceof FunctionEntryNode;
    }

    protected boolean isProgramExit(CFANode pLoc) {
        return pLoc.getNumLeavingEdges() == 0;
    }

    private boolean isBeforeFunctionCall(CFANode succLoc) {
        return succLoc.getLeavingSummaryEdge() != null;
    }

    private static boolean isFirstLocationInMainFunctionBody(CFANode pLoc) {
        for (CFAEdge edge : CFAUtils.leavingEdges(pLoc)) {
            if (!(edge instanceof BlankEdge) || !edge.getDescription().equals("Function start dummy edge")) continue;
            return true;
        }
        return false;
    }
}

