/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableSortedSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public class FormulaMeasuring {
    private final FormulaManagerView managerView;

    public FormulaMeasuring(FormulaManagerView pManagerView) {
        this.managerView = pManagerView;
    }

    public FormulaMeasures measure(BooleanFormula formula) {
        FormulaMeasures result = new FormulaMeasures();
        this.managerView.getBooleanFormulaManager().visitRecursively(formula, (BooleanFormulaVisitor<TraversalProcess>)new FormulaMeasuringVisitor(this.managerView, result));
        return result;
    }

    private static class FormulaMeasuringVisitor
    extends DefaultBooleanFormulaVisitor<TraversalProcess> {
        private final FormulaMeasures measures;
        private final FormulaManagerView fmgr;

        FormulaMeasuringVisitor(FormulaManagerView pFmgr, FormulaMeasures pMeasures) {
            this.measures = pMeasures;
            this.fmgr = pFmgr;
        }

        protected TraversalProcess visitDefault() {
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            ++this.measures.atoms;
            BooleanFormula atom = this.fmgr.uninstantiate(pAtom);
            this.measures.variables.addAll(this.fmgr.extractVariableNames((Formula)atom));
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitNot(BooleanFormula pOperand) {
            ++this.measures.negations;
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitAnd(List<BooleanFormula> pOperands) {
            ++this.measures.conjunctions;
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitOr(List<BooleanFormula> pOperands) {
            ++this.measures.disjunctions;
            return TraversalProcess.CONTINUE;
        }
    }

    public static class FormulaMeasures {
        private int conjunctions = 0;
        private int disjunctions = 0;
        private int negations = 0;
        private int atoms = 0;
        private final Set<String> variables = new HashSet<String>();

        public int getAtoms() {
            return this.atoms;
        }

        public int getConjunctions() {
            return this.conjunctions;
        }

        public int getDisjunctions() {
            return this.disjunctions;
        }

        public int getNegations() {
            return this.negations;
        }

        public ImmutableSortedSet<String> getVariables() {
            return ImmutableSortedSet.copyOf(this.variables);
        }
    }
}

