/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pseudoQE.PseudoExistQeManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate.refinement.newtonrefinement")
public class NewtonRefinementManager
implements StatisticsProvider {
    private final LogManager logger;
    private final Solver solver;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final PathFormulaManager pfmgr;
    private final PseudoExistQeManager qeManager;
    private final NewtonStatistics stats = new NewtonStatistics();
    @Option(secure=true, description="use unsatisfiable Core in order to abstract the predicates produced while NewtonRefinement")
    private boolean infeasibleCore = true;
    @Option(secure=true, description="use live variables in order to abstract the predicates produced while NewtonRefinement")
    private boolean liveVariables = true;
    @Option(secure=true, description="sets the level of the pathformulas to use for abstraction. \n  EDGE : Based on Pathformulas of every edge in ARGPath\n  BLOCK: Based on Pathformulas at Abstractionstates")
    private PathFormulaAbstractionLevel abstractionLevel = PathFormulaAbstractionLevel.EDGE;
    @Option(secure=true, description="Activate fallback to interpolation. Typically in case of a repeated counterexample.")
    private boolean fallback = false;

    public NewtonRefinementManager(LogManager pLogger, Solver pSolver, PathFormulaManager pPfmgr, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this, NewtonRefinementManager.class);
        this.logger = pLogger;
        this.solver = pSolver;
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pfmgr = pPfmgr;
        this.qeManager = new PseudoExistQeManager(this.solver, config, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterexampleTraceInfo buildCounterexampleTrace(ARGPath pAllStatesTrace, BlockFormulaStrategy.BlockFormulas pFormulas) throws RefinementFailedException, InterruptedException {
        ++this.stats.noOfRefinements;
        this.stats.totalTimer.start();
        try {
            List<BooleanFormula> predicates;
            List<PathLocation> pathLocations = this.buildPathLocationList(pAllStatesTrace);
            if (this.isFeasible((List<BooleanFormula>)pFormulas.getFormulas(), pAllStatesTrace)) {
                CounterexampleTraceInfo counterexampleTraceInfo = CounterexampleTraceInfo.feasibleImprecise(pFormulas.getFormulas());
                return counterexampleTraceInfo;
            }
            switch (this.abstractionLevel) {
                case EDGE: {
                    predicates = this.createPredicatesEdgeLevel(pAllStatesTrace, pFormulas, pathLocations);
                    break;
                }
                case BLOCK: {
                    predicates = this.createPredicatesBlockLevel(pAllStatesTrace, pFormulas, pathLocations);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The selected PathFormulaAbstractionLevel is not implemented.");
                }
            }
            try {
                if (!this.solver.isUnsat(predicates.get(predicates.size() - 1))) {
                    throw new RefinementFailedException(RefinementFailedException.Reason.SequenceOfAssertionsToWeak, pAllStatesTrace);
                }
            }
            catch (SolverException e) {
                throw new RefinementFailedException(RefinementFailedException.Reason.NewtonRefinementFailed, pAllStatesTrace, e);
            }
            if (this.liveVariables) {
                predicates = this.filterFutureLiveVariables(pathLocations, predicates);
            }
            CounterexampleTraceInfo counterexampleTraceInfo = CounterexampleTraceInfo.infeasible(predicates.subList(0, predicates.size() - 1));
            return counterexampleTraceInfo;
        }
        finally {
            this.stats.totalTimer.stop();
        }
    }

    public boolean fallbackToInterpolation() {
        return this.fallback;
    }

    private List<BooleanFormula> createPredicatesEdgeLevel(ARGPath pPath, BlockFormulaStrategy.BlockFormulas pFormulas, List<PathLocation> pathLocations) throws RefinementFailedException, InterruptedException {
        ImmutableList pathFormulas = Collections3.transformedImmutableListCopy(pathLocations, l -> l.getPathFormula().getFormula());
        assert (this.isFeasible((List<BooleanFormula>)pFormulas.getFormulas(), pPath) == this.isFeasible((List<BooleanFormula>)pathFormulas, pPath));
        Optional<List<BooleanFormula>> unsatCore = this.infeasibleCore ? Optional.of(this.computeUnsatCore((List<BooleanFormula>)pathFormulas, pPath)) : Optional.empty();
        return this.calculateStrongestPostCondition(pathLocations, unsatCore);
    }

    private List<BooleanFormula> createPredicatesBlockLevel(ARGPath pPath, BlockFormulaStrategy.BlockFormulas pFormulas, List<PathLocation> pPathLocations) throws InterruptedException, RefinementFailedException {
        List<BooleanFormula> unsatCore = this.computeUnsatCore((List<BooleanFormula>)pFormulas.getFormulas(), pPath);
        ArrayList<BooleanFormula> predicates = new ArrayList<BooleanFormula>();
        UnmodifiableIterator abstractionLocations = ((ImmutableList)pPathLocations.stream().filter(l -> l.hasAbstractionState()).collect(ImmutableList.toImmutableList())).iterator();
        BooleanFormula pred = this.bfmgr.makeTrue();
        for (BooleanFormula pathFormula : pFormulas.getFormulas()) {
            assert (abstractionLocations.hasNext());
            PathFormula pathFormulaWithSsa = ((PathLocation)abstractionLocations.next()).getPathFormula();
            if (unsatCore.contains(pathFormula)) {
                pred = this.bfmgr.and(pred, pathFormula);
                pred = this.eliminateIntermediateVariables(pathFormulaWithSsa, pred);
                pred = this.fmgr.simplify(pred);
            }
            predicates.add(pred);
        }
        return ImmutableList.copyOf(predicates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BooleanFormula> calculateStrongestPostCondition(List<PathLocation> pPathLocations, Optional<List<BooleanFormula>> pUnsatCore) throws InterruptedException, RefinementFailedException {
        this.logger.log(Level.FINE, new Object[]{"Calculate Strongest Postcondition for the error trace."});
        this.stats.postConditionTimer.start();
        try {
            BooleanFormula preCondition = this.bfmgr.makeTrue();
            ArrayList<BooleanFormula> predicates = new ArrayList<BooleanFormula>();
            for (PathLocation location : pPathLocations) {
                BooleanFormula postCondition;
                CFAEdge edge = location.getLastEdge();
                PathFormula pathFormula = location.getPathFormula();
                ArrayList<BooleanFormula> requiredPart = new ArrayList<BooleanFormula>();
                if (pUnsatCore.isPresent()) {
                    Set pathFormulaElements = this.bfmgr.toConjunctionArgs(pathFormula.getFormula(), true);
                    for (BooleanFormula pathFormulaElement : pathFormulaElements) {
                        if (!pUnsatCore.orElseThrow().contains(pathFormulaElement)) continue;
                        requiredPart.add(pathFormulaElement);
                        break;
                    }
                } else {
                    requiredPart.add(pathFormula.getFormula());
                }
                switch (edge.getEdgeType()) {
                    case AssumeEdge: {
                        if (!requiredPart.isEmpty()) {
                            postCondition = this.eliminateIntermediateVariables(pathFormula, this.bfmgr.and(preCondition, this.bfmgr.and(requiredPart)));
                            break;
                        }
                        postCondition = preCondition;
                        break;
                    }
                    case StatementEdge: 
                    case DeclarationEdge: 
                    case FunctionCallEdge: 
                    case ReturnStatementEdge: 
                    case FunctionReturnEdge: {
                        postCondition = this.calculatePostconditionForAssignment(preCondition, pathFormula, requiredPart);
                        break;
                    }
                    default: {
                        if (this.bfmgr.isTrue(pathFormula.getFormula())) {
                            this.logger.log(Level.FINE, new Object[]{"Pathformula is True, so no additional Formula in PostCondition for EdgeType: ", edge.getEdgeType()});
                            postCondition = preCondition;
                            break;
                        }
                        throw new UnsupportedOperationException("Found unsupported EdgeType in Newton Refinement: " + edge.getDescription() + " of Type :" + edge.getEdgeType());
                    }
                }
                if (location.hasCorrespondingARGState() && location.hasAbstractionState()) {
                    predicates.add(postCondition);
                }
                preCondition = postCondition;
            }
            ImmutableList immutableList = ImmutableList.copyOf(predicates);
            return immutableList;
        }
        finally {
            this.stats.postConditionTimer.stop();
        }
    }

    private BooleanFormula calculatePostconditionForAssignment(BooleanFormula preCondition, PathFormula pathFormula, List<BooleanFormula> requiredPart) throws InterruptedException {
        BooleanFormula toExist = !requiredPart.isEmpty() ? this.bfmgr.and(preCondition, this.bfmgr.and(requiredPart)) : preCondition;
        if (toExist == this.bfmgr.makeTrue()) {
            return toExist;
        }
        return this.eliminateIntermediateVariables(pathFormula, toExist);
    }

    private BooleanFormula eliminateIntermediateVariables(PathFormula pathFormula, BooleanFormula toExist) throws InterruptedException {
        ImmutableMap intermediateVars = ImmutableMap.copyOf((Map)Maps.filterKeys(this.fmgr.extractVariables((Formula)toExist), varName -> this.fmgr.isIntermediate((String)varName, pathFormula.getSsa())));
        if (intermediateVars.isEmpty()) {
            return toExist;
        }
        Optional<BooleanFormula> result = this.qeManager.eliminateQuantifiers((Map<String, Formula>)intermediateVars, toExist);
        if (result.isPresent()) {
            return result.orElseThrow();
        }
        this.logger.log(Level.FINE, new Object[]{"Quantifier elimination failed, keeping old assignments in predicate."});
        return toExist;
    }

    private boolean isFeasible(List<BooleanFormula> pFormulas, ARGPath pPath) throws RefinementFailedException, InterruptedException {
        boolean isFeasible;
        this.logger.log(Level.FINEST, new Object[]{"Show feasiblity for:", pFormulas});
        try (ProverEnvironment prover = this.solver.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            for (BooleanFormula formula : pFormulas) {
                prover.push(formula);
            }
            isFeasible = !prover.isUnsat();
        }
        catch (SolverException e) {
            throw new RefinementFailedException(RefinementFailedException.Reason.NewtonRefinementFailed, pPath, e);
        }
        this.logger.log(Level.FINEST, new Object[]{isFeasible ? "The trace is feasible." : "The trace is infeasible"});
        return isFeasible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BooleanFormula> computeUnsatCore(List<BooleanFormula> pFormulas, ARGPath pPath) throws RefinementFailedException, InterruptedException {
        this.stats.unsatCoreTimer.start();
        try {
            List<BooleanFormula> unsatCore;
            this.logger.log(Level.FINEST, new Object[]{"Compute unsatisfiable core of: ", pFormulas});
            try {
                unsatCore = this.solver.unsatCore((Set<BooleanFormula>)ImmutableSet.copyOf(pFormulas));
            }
            catch (SolverException e) {
                throw new RefinementFailedException(RefinementFailedException.Reason.NewtonRefinementFailed, pPath, e);
            }
            this.logger.log(Level.FINEST, new Object[]{"Unsatisfiable Core is: ", unsatCore});
            ImmutableList immutableList = ImmutableList.copyOf(unsatCore);
            return immutableList;
        }
        finally {
            this.stats.unsatCoreTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BooleanFormula> filterFutureLiveVariables(List<PathLocation> pPathLocations, List<BooleanFormula> pPredicates) throws InterruptedException {
        this.stats.futureLivesTimer.start();
        try {
            HashSet<String> variablesToTest = new HashSet<String>();
            for (BooleanFormula pred : pPredicates) {
                variablesToTest.addAll(this.fmgr.extractVariableNames((Formula)pred));
            }
            HashMap<String, Integer> lastOccurance = new HashMap<String, Integer>();
            TreeMap<Integer, BooleanFormula> predPosition = new TreeMap<Integer, BooleanFormula>();
            int predCounter = 0;
            for (PathLocation location : pPathLocations) {
                Set<String> localVars = this.fmgr.extractVariableNames((Formula)location.getPathFormula().getFormula());
                for (String var : variablesToTest) {
                    if (!localVars.contains(var)) continue;
                    lastOccurance.put(var, location.getPathPosition());
                }
                if (!location.hasAbstractionState() || predCounter >= pPredicates.size()) continue;
                predPosition.put(location.getPathPosition(), pPredicates.get(predCounter));
                ++predCounter;
            }
            assert (predPosition.size() == pPredicates.size());
            ArrayList<BooleanFormula> newPredicates = new ArrayList<BooleanFormula>();
            for (Map.Entry predEntry : predPosition.entrySet()) {
                BooleanFormula pred = (BooleanFormula)predEntry.getValue();
                int predPos = (Integer)predEntry.getKey();
                Set futureLives = Maps.filterValues(lastOccurance, v -> v > predPos).keySet();
                Map toQuantify = Maps.filterKeys(this.fmgr.extractVariables((Formula)pred), varName -> !futureLives.contains(varName));
                if (!toQuantify.isEmpty()) {
                    Optional<BooleanFormula> quantifiedPred = this.qeManager.eliminateQuantifiers(toQuantify, pred);
                    if (quantifiedPred.isPresent()) {
                        newPredicates.add(quantifiedPred.orElseThrow());
                        this.stats.noOfQuantifiedFutureLives += toQuantify.size();
                        continue;
                    }
                    newPredicates.add(pred);
                    continue;
                }
                newPredicates.add(pred);
            }
            assert (newPredicates.size() == pPredicates.size());
            ArrayList<BooleanFormula> arrayList = newPredicates;
            return arrayList;
        }
        finally {
            this.stats.futureLivesTimer.stop();
        }
    }

    private List<PathLocation> buildPathLocationList(ARGPath pPath) throws RefinementFailedException, InterruptedException {
        ArrayList<PathLocation> pathLocationList = new ArrayList<PathLocation>();
        PathIterator pathIterator = pPath.fullPathIterator();
        PathFormula pathFormula = this.pfmgr.makeEmptyPathFormula();
        int pos = 0;
        while (pathIterator.hasNext()) {
            pathIterator.advance();
            CFAEdge lastEdge = pathIterator.getIncomingEdge();
            Optional<ARGState> state = pathIterator.isPositionWithState() ? Optional.of(pathIterator.getAbstractState()) : Optional.empty();
            try {
                pathFormula = this.pfmgr.makeAnd(this.pfmgr.makeEmptyPathFormulaWithContextFrom(pathFormula), lastEdge);
            }
            catch (CPATransferException e) {
                throw new RefinementFailedException(RefinementFailedException.Reason.NewtonRefinementFailed, pPath, e);
            }
            pathLocationList.add(new PathLocation(pos, lastEdge, pathFormula, state));
            ++pos;
        }
        return pathLocationList;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        this.qeManager.collectStatistics(pStatsCollection);
    }

    private class NewtonStatistics
    implements Statistics {
        private int noOfRefinements = 0;
        private int noOfQuantifiedFutureLives = 0;
        private final Timer totalTimer = new Timer();
        private final Timer postConditionTimer = new Timer();
        private final Timer unsatCoreTimer = new Timer();
        private final Timer futureLivesTimer = new Timer();

        private NewtonStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            pOut.println("Number of Newton Refinements                : " + this.noOfRefinements);
            pOut.println("  Total Time spent                          : " + this.totalTimer.getSumTime());
            pOut.println("  Time spent for strongest postcondition    : " + this.postConditionTimer.getSumTime());
            if (NewtonRefinementManager.this.infeasibleCore) {
                pOut.println("  Time spent for unsat Core                 : " + this.unsatCoreTimer.getSumTime());
            }
            if (NewtonRefinementManager.this.liveVariables) {
                pOut.println("  Time spent for Live Variable projection   : " + this.futureLivesTimer.getSumTime());
                pOut.println("  Number of quantified Future Live variables: " + this.noOfQuantifiedFutureLives);
            }
        }

        @Override
        public @Nullable String getName() {
            return "Newton Refinement Algorithm";
        }
    }

    private static class PathLocation {
        final int pos;
        final CFAEdge lastEdge;
        final PathFormula pathFormula;
        final Optional<ARGState> state;

        PathLocation(int pPosition, CFAEdge pLastEdge, PathFormula pPathFormula, Optional<ARGState> pState) {
            this.pos = pPosition;
            this.lastEdge = pLastEdge;
            this.pathFormula = pPathFormula;
            this.state = pState;
        }

        int getPathPosition() {
            return this.pos;
        }

        CFAEdge getLastEdge() {
            return this.lastEdge;
        }

        PathFormula getPathFormula() {
            return this.pathFormula;
        }

        boolean hasCorrespondingARGState() {
            return this.state.isPresent();
        }

        boolean hasAbstractionState() {
            if (this.hasCorrespondingARGState()) {
                return PredicateAbstractState.getPredicateState(this.state.orElseThrow()).isAbstractionState();
            }
            return false;
        }

        public String toString() {
            return (String)(this.lastEdge != null ? this.lastEdge.toString() : "First State: " + this.state.orElseThrow().toDOTLabel()) + ", PathFormula: " + this.pathFormula;
        }
    }

    public static enum PathFormulaAbstractionLevel {
        BLOCK,
        EDGE;

    }
}

